/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.core.http;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import no.nav.security.token.support.client.core.http.OAuth2HttpHeaders;

public class OAuth2HttpRequest {
    private final URI tokenEndpointUrl;
    private final OAuth2HttpHeaders oAuth2HttpHeaders;
    private final Map<String, String> formParameters;

    OAuth2HttpRequest(URI tokenEndpointUrl, OAuth2HttpHeaders oAuth2HttpHeaders, Map<String, String> formParameters) {
        this.tokenEndpointUrl = tokenEndpointUrl;
        this.oAuth2HttpHeaders = oAuth2HttpHeaders;
        this.formParameters = formParameters;
    }

    public static OAuth2HttpRequestBuilder builder() {
        return new OAuth2HttpRequestBuilder();
    }

    public URI getTokenEndpointUrl() {
        return this.tokenEndpointUrl;
    }

    public OAuth2HttpHeaders getOAuth2HttpHeaders() {
        return this.oAuth2HttpHeaders;
    }

    public Map<String, String> getFormParameters() {
        return this.formParameters;
    }

    public static class OAuth2HttpRequestBuilder {
        private URI tokenEndpointUrl;
        private OAuth2HttpHeaders oAuth2HttpHeaders;
        private List<String> keys;
        private List<String> values;

        OAuth2HttpRequestBuilder() {
        }

        public OAuth2HttpRequestBuilder tokenEndpointUrl(URI tokenEndpointUrl) {
            this.tokenEndpointUrl = tokenEndpointUrl;
            return this;
        }

        public OAuth2HttpRequestBuilder oAuth2HttpHeaders(OAuth2HttpHeaders oAuth2HttpHeaders) {
            this.oAuth2HttpHeaders = oAuth2HttpHeaders;
            return this;
        }

        public OAuth2HttpRequestBuilder formParameter(String formParameterKey, String formParameterValue) {
            if (this.keys == null) {
                this.keys = new ArrayList<String>();
                this.values = new ArrayList<String>();
            }
            this.keys.add(formParameterKey);
            this.values.add(formParameterValue);
            return this;
        }

        public OAuth2HttpRequestBuilder formParameters(Map<? extends String, ? extends String> formParameters) {
            if (this.keys == null) {
                this.keys = new ArrayList<String>();
                this.values = new ArrayList<String>();
            }
            formParameters.forEach((key, value) -> {
                this.keys.add((String)key);
                this.values.add((String)value);
            });
            return this;
        }

        public OAuth2HttpRequestBuilder clearFormParameters() {
            if (this.keys != null) {
                this.keys.clear();
                this.values.clear();
            }
            return this;
        }

        public OAuth2HttpRequest build() {
            switch (this.keys == null ? 0 : this.keys.size()) {
                case 0: {
                    return new OAuth2HttpRequest(this.tokenEndpointUrl, this.oAuth2HttpHeaders, Map.of());
                }
                case 1: {
                    return new OAuth2HttpRequest(this.tokenEndpointUrl, this.oAuth2HttpHeaders, Map.of(this.keys.get(0), this.values.get(0)));
                }
            }
            LinkedHashMap<String, String> formParameters = new LinkedHashMap<String, String>(this.keys.size());
            for (int i = 0; i < this.keys.size(); ++i) {
                formParameters.put(this.keys.get(i), this.values.get(i));
            }
            return new OAuth2HttpRequest(this.tokenEndpointUrl, this.oAuth2HttpHeaders, Collections.unmodifiableMap(formParameters));
        }

        public String toString() {
            return "OAuth2HttpRequest.OAuth2HttpRequestBuilder(tokenEndpointUrl=" + this.tokenEndpointUrl + ", oAuth2HttpHeaders=" + this.oAuth2HttpHeaders + ", keys=" + this.keys + ", values=" + this.values + ")";
        }
    }
}

