/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.core.http;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;

public class OAuth2HttpHeaders {
    private final Map<String, List<String>> headers;

    private OAuth2HttpHeaders(Map<String, List<String>> headers) {
        this.headers = Optional.ofNullable(headers).orElse(Map.of());
    }

    public static OAuth2HttpHeaders of(Map<String, List<String>> headers) {
        return new OAuth2HttpHeaders(headers);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2HttpHeaders that = (OAuth2HttpHeaders)o;
        return Objects.equals(this.headers, that.headers);
    }

    public int hashCode() {
        return Objects.hash(this.headers);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [headers=" + this.headers + "]";
    }

    public static class Builder {
        private final TreeMap<String, List<String>> headersMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);

        public Builder header(String name, String value) {
            this.headersMap.computeIfAbsent(name, k -> new ArrayList(1)).add(value);
            return this;
        }

        public OAuth2HttpHeaders build() {
            return OAuth2HttpHeaders.of(this.headersMap);
        }
    }
}

