/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.core;

import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import no.nav.security.token.support.client.core.jwk.JwkFactory;

public class ClientAuthenticationProperties {
    private static final List<ClientAuthenticationMethod> CLIENT_AUTH_METHODS = List.of(ClientAuthenticationMethod.CLIENT_SECRET_BASIC, ClientAuthenticationMethod.CLIENT_SECRET_POST, ClientAuthenticationMethod.PRIVATE_KEY_JWT);
    @NotNull
    private final String clientId;
    private final ClientAuthenticationMethod clientAuthMethod;
    private final String clientSecret;
    private final String clientJwk;
    private final RSAKey clientRsaKey;

    public ClientAuthenticationProperties(@NotNull String clientId, ClientAuthenticationMethod clientAuthMethod, String clientSecret, String clientJwk) {
        this.clientId = clientId;
        this.clientAuthMethod = ClientAuthenticationProperties.getSupported(clientAuthMethod);
        this.clientSecret = clientSecret;
        this.clientJwk = clientJwk;
        this.clientRsaKey = ClientAuthenticationProperties.loadKey(clientJwk);
        this.validateAfterPropertiesSet();
    }

    private static RSAKey loadKey(String clientPrivateKey) {
        if (clientPrivateKey != null) {
            if (clientPrivateKey.startsWith("{")) {
                return JwkFactory.fromJson(clientPrivateKey);
            }
            return JwkFactory.fromJsonFile(clientPrivateKey);
        }
        return null;
    }

    private static ClientAuthenticationMethod getSupported(ClientAuthenticationMethod clientAuthMethod) {
        return clientAuthMethod == null ? ClientAuthenticationMethod.CLIENT_SECRET_BASIC : Optional.of(clientAuthMethod).filter(CLIENT_AUTH_METHODS::contains).orElseThrow(() -> new IllegalArgumentException(String.format("unsupported %s with value %s, must be one of %s", ClientAuthenticationMethod.class.getSimpleName(), clientAuthMethod, CLIENT_AUTH_METHODS)));
    }

    public static ClientAuthenticationPropertiesBuilder builder() {
        return new ClientAuthenticationPropertiesBuilder();
    }

    private void validateAfterPropertiesSet() {
        Objects.requireNonNull(this.clientId, "clientId cannot be null");
        if (ClientAuthenticationMethod.CLIENT_SECRET_BASIC.equals((Object)this.clientAuthMethod)) {
            Objects.requireNonNull(this.clientSecret, "clientSecret cannot be null");
        } else if (ClientAuthenticationMethod.CLIENT_SECRET_POST.equals((Object)this.clientAuthMethod)) {
            Objects.requireNonNull(this.clientSecret, "clientSecret cannot be null");
        } else if (ClientAuthenticationMethod.PRIVATE_KEY_JWT.equals((Object)this.clientAuthMethod)) {
            Objects.requireNonNull(this.clientJwk, "clientPrivateKey must be set");
        }
    }

    @NotNull
    public String getClientId() {
        return this.clientId;
    }

    public ClientAuthenticationMethod getClientAuthMethod() {
        return this.clientAuthMethod;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getClientJwk() {
        return this.clientJwk;
    }

    public RSAKey getClientRsaKey() {
        return this.clientRsaKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientAuthenticationProperties that = (ClientAuthenticationProperties)o;
        return Objects.equals(this.clientId, that.clientId) && Objects.equals(this.clientAuthMethod, that.clientAuthMethod) && Objects.equals(this.clientSecret, that.clientSecret) && Objects.equals(this.clientJwk, that.clientJwk) && Objects.equals(this.clientRsaKey, that.clientRsaKey);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.clientAuthMethod, this.clientSecret, this.clientJwk, this.clientRsaKey);
    }

    public String toString() {
        return "ClientAuthenticationProperties(clientId=" + this.getClientId() + ", clientAuthMethod=" + this.getClientAuthMethod() + ", clientSecret=" + this.getClientSecret() + ", clientJwk=" + this.getClientJwk() + ", clientRsaKey=" + this.getClientRsaKey() + ")";
    }

    public ClientAuthenticationPropertiesBuilder toBuilder() {
        return new ClientAuthenticationPropertiesBuilder().clientId(this.clientId).clientAuthMethod(this.clientAuthMethod).clientSecret(this.clientSecret).clientJwk(this.clientJwk);
    }

    public static class ClientAuthenticationPropertiesBuilder {
        @NotNull
        private String clientId;
        private ClientAuthenticationMethod clientAuthMethod;
        private String clientSecret;
        private String clientJwk;

        ClientAuthenticationPropertiesBuilder() {
        }

        public ClientAuthenticationPropertiesBuilder clientId(@NotNull String clientId) {
            this.clientId = clientId;
            return this;
        }

        public ClientAuthenticationPropertiesBuilder clientAuthMethod(ClientAuthenticationMethod clientAuthMethod) {
            this.clientAuthMethod = clientAuthMethod;
            return this;
        }

        public ClientAuthenticationPropertiesBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public ClientAuthenticationPropertiesBuilder clientJwk(String clientJwk) {
            this.clientJwk = clientJwk;
            return this;
        }

        public ClientAuthenticationProperties build() {
            return new ClientAuthenticationProperties(this.clientId, this.clientAuthMethod, this.clientSecret, this.clientJwk);
        }

        public String toString() {
            return "ClientAuthenticationProperties.ClientAuthenticationPropertiesBuilder(clientId=" + this.clientId + ", clientAuthMethod=" + this.clientAuthMethod + ", clientSecret=" + this.clientSecret + ", clientJwk=" + this.clientJwk + ")";
        }
    }
}

