/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.core.oauth2;

import java.util.LinkedHashMap;
import java.util.Map;
import no.nav.security.token.support.client.core.ClientProperties;
import no.nav.security.token.support.client.core.http.OAuth2HttpClient;
import no.nav.security.token.support.client.core.oauth2.AbstractOAuth2TokenClient;
import no.nav.security.token.support.client.core.oauth2.TokenExchangeGrantRequest;

public class TokenExchangeClient
extends AbstractOAuth2TokenClient<TokenExchangeGrantRequest> {
    public TokenExchangeClient(OAuth2HttpClient oAuth2HttpClient) {
        super(oAuth2HttpClient);
    }

    @Override
    protected Map<String, String> formParameters(TokenExchangeGrantRequest grantRequest) {
        LinkedHashMap<String, String> formParameters = new LinkedHashMap<String, String>();
        ClientProperties.TokenExchangeProperties tokenExchangeProperties = grantRequest.getClientProperties().getTokenExchange();
        formParameters.put("subject_token_type", tokenExchangeProperties.subjectTokenType());
        formParameters.put("subject_token", grantRequest.getSubjectToken());
        formParameters.put("audience", tokenExchangeProperties.getAudience());
        if (tokenExchangeProperties.getResource() != null && !tokenExchangeProperties.getResource().isEmpty()) {
            formParameters.put("resource", tokenExchangeProperties.getResource());
        }
        return formParameters;
    }
}

