/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.core.auth;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.net.URI;
import java.time.Instant;
import java.util.Date;
import java.util.UUID;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.token.support.client.core.ClientAuthenticationProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0019\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u000e\u001a\n \u000f*\u0004\u0018\u00010\b0\bJ\b\u0010\u0010\u001a\u00020\bH\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lno/nav/security/token/support/client/core/auth/ClientAssertion;", "", "tokenEndpointUrl", "Ljava/net/URI;", "auth", "Lno/nav/security/token/support/client/core/ClientAuthenticationProperties;", "(Ljava/net/URI;Lno/nav/security/token/support/client/core/ClientAuthenticationProperties;)V", "clientId", "", "rsaKey", "Lcom/nimbusds/jose/jwk/RSAKey;", "expiryInSeconds", "", "(Ljava/net/URI;Ljava/lang/String;Lcom/nimbusds/jose/jwk/RSAKey;I)V", "assertion", "kotlin.jvm.PlatformType", "assertionType", "createSignedJWT", "Lcom/nimbusds/jwt/SignedJWT;", "rsaJwk", "claimsSet", "Lcom/nimbusds/jwt/JWTClaimsSet;", "Companion", "token-client-core"})
public final class ClientAssertion {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final URI tokenEndpointUrl;
    @NotNull
    private final String clientId;
    @NotNull
    private final RSAKey rsaKey;
    private final int expiryInSeconds;
    private static final int EXPIRY_IN_SECONDS = 60;

    public ClientAssertion(@Nullable URI tokenEndpointUrl, @NotNull String clientId, @NotNull RSAKey rsaKey, int expiryInSeconds) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)rsaKey, (String)"rsaKey");
        this.tokenEndpointUrl = tokenEndpointUrl;
        this.clientId = clientId;
        this.rsaKey = rsaKey;
        this.expiryInSeconds = expiryInSeconds;
    }

    public ClientAssertion(@Nullable URI tokenEndpointUrl, @NotNull ClientAuthenticationProperties auth) {
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        String string = auth.getClientId();
        RSAKey rSAKey = auth.getClientRsaKey();
        Intrinsics.checkNotNull((Object)rSAKey);
        this(tokenEndpointUrl, string, rSAKey, 60);
    }

    public final String assertion() {
        Instant $this$assertion_u24lambda_u240 = Instant.now();
        boolean bl = false;
        JWTClaimsSet jWTClaimsSet = new JWTClaimsSet.Builder().audience(String.valueOf(this.tokenEndpointUrl)).expirationTime(Date.from($this$assertion_u24lambda_u240.plusSeconds(this.expiryInSeconds))).issuer(this.clientId).subject(this.clientId).claim("jti", (Object)String.valueOf(UUID.randomUUID())).notBeforeTime(Date.from($this$assertion_u24lambda_u240)).issueTime(Date.from($this$assertion_u24lambda_u240)).build();
        Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet, (String)"build(...)");
        return this.createSignedJWT(this.rsaKey, jWTClaimsSet).serialize();
    }

    @Deprecated(message="Use com.nimbusds.oauth2.sdk.auth.JWTAuthentication instead", replaceWith=@ReplaceWith(expression="JWTAuthentication.CLIENT_ASSERTION_TYPE", imports={}), level=DeprecationLevel.WARNING)
    @NotNull
    public final String assertionType() {
        return "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";
    }

    private final SignedJWT createSignedJWT(RSAKey rsaJwk, JWTClaimsSet claimsSet) {
        Object $this$createSignedJWT_u24lambda_u242;
        Object object = this;
        try {
            SignedJWT signedJWT;
            $this$createSignedJWT_u24lambda_u242 = object;
            boolean bl = false;
            SignedJWT $this$createSignedJWT_u24lambda_u242_u24lambda_u241 = signedJWT = new SignedJWT(new JWSHeader.Builder(JWSAlgorithm.RS256).keyID(rsaJwk.getKeyID()).type(JOSEObjectType.JWT).build(), claimsSet);
            boolean bl2 = false;
            $this$createSignedJWT_u24lambda_u242_u24lambda_u241.sign((JWSSigner)new RSASSASigner(rsaJwk.toPrivateKey()));
            $this$createSignedJWT_u24lambda_u242 = Result.constructor-impl((Object)signedJWT);
        }
        catch (Throwable bl) {
            $this$createSignedJWT_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$createSignedJWT_u24lambda_u242;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            throw new RuntimeException(it);
        }
        return (SignedJWT)object;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lno/nav/security/token/support/client/core/auth/ClientAssertion$Companion;", "", "()V", "EXPIRY_IN_SECONDS", "", "token-client-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

