/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.core.jwk;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.util.Base64URL;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b2\u0006\u0010\n\u001a\u00020\u0004H\u0007J\u0018\u0010\u000b\u001a\n \t*\u0004\u0018\u00010\b0\b2\u0006\u0010\f\u001a\u00020\u0004H\u0007J \u0010\r\u001a\n \t*\u0004\u0018\u00010\u000e0\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J(\u0010\r\u001a\n \t*\u0004\u0018\u00010\b0\b2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0007J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\bH\u0002\u00a8\u0006\u0016"}, d2={"Lno/nav/security/token/support/client/core/jwk/JwkFactory;", "", "()V", "createSHA1DigestBase64Url", "", "bytes", "", "fromJson", "Lcom/nimbusds/jose/jwk/RSAKey;", "kotlin.jvm.PlatformType", "jwk", "fromJsonFile", "filePath", "fromKeyStore", "Lcom/nimbusds/jose/jwk/JWKSet;", "keyStoreFile", "Ljava/io/InputStream;", "password", "alias", "getX509CertSHA1Thumbprint", "rsaKey", "JwkInvalidException", "token-client-core"})
@SourceDebugExtension(value={"SMAP\nJwkFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JwkFactory.kt\nno/nav/security/token/support/client/core/jwk/JwkFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1#2:72\n*E\n"})
public final class JwkFactory {
    @NotNull
    public static final JwkFactory INSTANCE = new JwkFactory();

    private JwkFactory() {
    }

    @JvmStatic
    public static final RSAKey fromJsonFile(@NotNull String filePath) {
        Object $this$fromJsonFile_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Object object = INSTANCE;
        try {
            $this$fromJsonFile_u24lambda_u240 = object;
            boolean bl = false;
            String string = Files.readString(Path.of(filePath, new String[0]).toAbsolutePath(), StandardCharsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
            $this$fromJsonFile_u24lambda_u240 = Result.constructor-impl((Object)JwkFactory.fromJson(string));
        }
        catch (Throwable bl) {
            $this$fromJsonFile_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$fromJsonFile_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            throw new JwkInvalidException(it);
        }
        return (RSAKey)object;
    }

    @JvmStatic
    public static final RSAKey fromJson(@NotNull String jwk) {
        Object $this$fromJson_u24lambda_u242;
        Intrinsics.checkNotNullParameter((Object)jwk, (String)"jwk");
        Object object = INSTANCE;
        try {
            $this$fromJson_u24lambda_u242 = object;
            boolean bl = false;
            $this$fromJson_u24lambda_u242 = Result.constructor-impl((Object)RSAKey.parse((String)jwk));
        }
        catch (Throwable bl) {
            $this$fromJson_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$fromJson_u24lambda_u242;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            throw new JwkInvalidException(it);
        }
        return (RSAKey)object;
    }

    @JvmStatic
    public static final RSAKey fromKeyStore(@NotNull String alias, @NotNull InputStream keyStoreFile, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        Intrinsics.checkNotNullParameter((Object)keyStoreFile, (String)"keyStoreFile");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        JWK jWK = INSTANCE.fromKeyStore(keyStoreFile, password).getKeyByKeyId(alias);
        Intrinsics.checkNotNull((Object)jWK, (String)"null cannot be cast to non-null type com.nimbusds.jose.jwk.RSAKey");
        RSAKey $this$fromKeyStore_u24lambda_u244 = (RSAKey)jWK;
        boolean bl = false;
        return new RSAKey.Builder($this$fromKeyStore_u24lambda_u244).keyID(INSTANCE.getX509CertSHA1Thumbprint($this$fromKeyStore_u24lambda_u244)).build();
    }

    private final JWKSet fromKeyStore(InputStream keyStoreFile, String password) {
        Object $this$fromKeyStore_u24lambda_u248;
        Object object = this;
        try {
            $this$fromKeyStore_u24lambda_u248 = object;
            boolean bl = false;
            KeyStore $this$fromKeyStore_u24lambda_u248_u24lambda_u247 = KeyStore.getInstance("JKS");
            boolean bl2 = false;
            char[] cArray = password.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            char[] $this$fromKeyStore_u24lambda_u248_u24lambda_u247_u24lambda_u246 = cArray;
            boolean bl3 = false;
            $this$fromKeyStore_u24lambda_u248_u24lambda_u247.load(keyStoreFile, $this$fromKeyStore_u24lambda_u248_u24lambda_u247_u24lambda_u246);
            $this$fromKeyStore_u24lambda_u248 = Result.constructor-impl((Object)JWKSet.load((KeyStore)$this$fromKeyStore_u24lambda_u248_u24lambda_u247, arg_0 -> JwkFactory.fromKeyStore$lambda$8$lambda$7$lambda$6$lambda$5($this$fromKeyStore_u24lambda_u248_u24lambda_u247_u24lambda_u246, arg_0)));
        }
        catch (Throwable bl) {
            $this$fromKeyStore_u24lambda_u248 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$fromKeyStore_u24lambda_u248;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            throw new RuntimeException(it);
        }
        return (JWKSet)object;
    }

    private final String getX509CertSHA1Thumbprint(RSAKey rsaKey) {
        Object $this$getX509CertSHA1Thumbprint_u24lambda_u2411;
        Object object = this;
        try {
            String string;
            $this$getX509CertSHA1Thumbprint_u24lambda_u2411 = object;
            boolean bl = false;
            List list = rsaKey.getParsedX509CertChain();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParsedX509CertChain(...)");
            X509Certificate x509Certificate = (X509Certificate)CollectionsKt.firstOrNull((List)list);
            if (x509Certificate != null) {
                X509Certificate cert = x509Certificate;
                boolean bl2 = false;
                byte[] byArray = cert.getEncoded();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
                string = super.createSHA1DigestBase64Url(byArray);
            } else {
                string = null;
            }
            $this$getX509CertSHA1Thumbprint_u24lambda_u2411 = Result.constructor-impl(string);
        }
        catch (Throwable bl) {
            $this$getX509CertSHA1Thumbprint_u24lambda_u2411 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$getX509CertSHA1Thumbprint_u24lambda_u2411;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            throw new RuntimeException(it);
        }
        return (String)object;
    }

    private final String createSHA1DigestBase64Url(byte[] bytes) {
        Object $this$createSHA1DigestBase64Url_u24lambda_u2413;
        Object object = this;
        try {
            $this$createSHA1DigestBase64Url_u24lambda_u2413 = object;
            boolean bl = false;
            $this$createSHA1DigestBase64Url_u24lambda_u2413 = Result.constructor-impl((Object)String.valueOf(Base64URL.encode((byte[])MessageDigest.getInstance("SHA-1").digest(bytes))));
        }
        catch (Throwable bl) {
            $this$createSHA1DigestBase64Url_u24lambda_u2413 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$createSHA1DigestBase64Url_u24lambda_u2413;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            throw new RuntimeException(it);
        }
        return (String)object;
    }

    private static final char[] fromKeyStore$lambda$8$lambda$7$lambda$6$lambda$5(char[] $this_with, String it) {
        Intrinsics.checkNotNullParameter((Object)$this_with, (String)"$this_with");
        return $this_with;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lno/nav/security/token/support/client/core/jwk/JwkFactory$JwkInvalidException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "cause", "", "(Ljava/lang/Throwable;)V", "token-client-core"})
    public static final class JwkInvalidException
    extends RuntimeException {
        public JwkInvalidException(@NotNull Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            super(cause);
        }
    }
}

