/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.core.oauth2;

import com.nimbusds.common.contenttype.ContentType;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.token.support.client.core.ClientAuthenticationProperties;
import no.nav.security.token.support.client.core.ClientProperties;
import no.nav.security.token.support.client.core.OAuth2ClientException;
import no.nav.security.token.support.client.core.auth.ClientAssertion;
import no.nav.security.token.support.client.core.http.OAuth2HttpClient;
import no.nav.security.token.support.client.core.http.OAuth2HttpHeaders;
import no.nav.security.token.support.client.core.http.OAuth2HttpRequest;
import no.nav.security.token.support.client.core.oauth2.AbstractOAuth2GrantRequest;
import no.nav.security.token.support.client.core.oauth2.OAuth2AccessTokenResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u00022\u00020\u0003B\u000f\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002J!\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\r\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u000eJ!\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\r\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u000eJ!\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\r\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\bH\u0016J8\u0010\u0016\u001a*\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00180\u0017j\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0018`\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lno/nav/security/token/support/client/core/oauth2/AbstractOAuth2TokenClient;", "T", "Lno/nav/security/token/support/client/core/oauth2/AbstractOAuth2GrantRequest;", "", "oAuth2HttpClient", "Lno/nav/security/token/support/client/core/http/OAuth2HttpClient;", "(Lno/nav/security/token/support/client/core/http/OAuth2HttpClient;)V", "basicAuth", "", "username", "password", "defaultClientAuthenticationFormParameters", "", "grantRequest", "(Lno/nav/security/token/support/client/core/oauth2/AbstractOAuth2GrantRequest;)Ljava/util/Map;", "defaultFormParameters", "formParameters", "", "getTokenResponse", "Lno/nav/security/token/support/client/core/oauth2/OAuth2AccessTokenResponse;", "(Lno/nav/security/token/support/client/core/oauth2/AbstractOAuth2GrantRequest;)Lno/nav/security/token/support/client/core/oauth2/OAuth2AccessTokenResponse;", "toString", "tokenRequestHeaders", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "clientProperties", "Lno/nav/security/token/support/client/core/ClientProperties;", "token-client-core"})
public abstract class AbstractOAuth2TokenClient<T extends AbstractOAuth2GrantRequest> {
    @NotNull
    private final OAuth2HttpClient oAuth2HttpClient;

    public AbstractOAuth2TokenClient(@NotNull OAuth2HttpClient oAuth2HttpClient) {
        Intrinsics.checkNotNullParameter((Object)oAuth2HttpClient, (String)"oAuth2HttpClient");
        this.oAuth2HttpClient = oAuth2HttpClient;
    }

    @NotNull
    protected abstract Map<String, String> formParameters(T var1);

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final OAuth2AccessTokenResponse getTokenResponse(T grantRequest) {
        OAuth2AccessTokenResponse oAuth2AccessTokenResponse;
        Object object = grantRequest;
        if (object != null && (object = ((AbstractOAuth2GrantRequest)object).getClientProperties()) != null) {
            Object $this$getTokenResponse_u24lambda_u243_u24lambda_u241;
            T it = object;
            boolean bl = false;
            Object object2 = this;
            try {
                void $this$getTokenResponse_u24lambda_u243_u24lambda_u241_u24lambda_u240;
                Map<String, String> map;
                $this$getTokenResponse_u24lambda_u243_u24lambda_u241 = object2;
                boolean bl2 = false;
                Map<String, String> map2 = map = super.defaultFormParameters(grantRequest);
                OAuth2HttpRequest.OAuth2HttpRequestBuilder oAuth2HttpRequestBuilder = OAuth2HttpRequest.Companion.builder(((ClientProperties)it).getTokenEndpointUrl()).oAuth2HttpHeaders(OAuth2HttpHeaders.Companion.of((Map<String, ? extends List<String>>)super.tokenRequestHeaders((ClientProperties)it)));
                OAuth2HttpClient oAuth2HttpClient = ((AbstractOAuth2TokenClient)$this$getTokenResponse_u24lambda_u243_u24lambda_u241).oAuth2HttpClient;
                boolean bl3 = false;
                $this$getTokenResponse_u24lambda_u243_u24lambda_u241_u24lambda_u240.putAll(((AbstractOAuth2TokenClient)$this$getTokenResponse_u24lambda_u243_u24lambda_u241).formParameters(grantRequest));
                Unit unit = Unit.INSTANCE;
                $this$getTokenResponse_u24lambda_u243_u24lambda_u241 = Result.constructor-impl((Object)oAuth2HttpClient.post(oAuth2HttpRequestBuilder.formParameters(map).build()));
            }
            catch (Throwable bl2) {
                $this$getTokenResponse_u24lambda_u243_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object2 = $this$getTokenResponse_u24lambda_u243_u24lambda_u241;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Throwable e = throwable;
                boolean bl4 = false;
                if (!(e instanceof OAuth2ClientException)) {
                    throw new OAuth2ClientException("Received exception " + e + " when invoking token endpoint=" + ((ClientProperties)it).getTokenEndpointUrl(), e);
                }
                throw e;
            }
            oAuth2AccessTokenResponse = (OAuth2AccessTokenResponse)object2;
        } else {
            oAuth2AccessTokenResponse = null;
        }
        return oAuth2AccessTokenResponse;
    }

    private final HashMap<String, List<String>> tokenRequestHeaders(ClientProperties clientProperties) {
        HashMap<String, List<String>> hashMap;
        HashMap<String, List<String>> $this$tokenRequestHeaders_u24lambda_u245 = hashMap = new HashMap<String, List<String>>();
        boolean bl = false;
        $this$tokenRequestHeaders_u24lambda_u245.put("Accept", CollectionsKt.listOf((Object)String.valueOf(ContentType.APPLICATION_JSON)));
        $this$tokenRequestHeaders_u24lambda_u245.put("Content-Type", CollectionsKt.listOf((Object)String.valueOf(ContentType.APPLICATION_URLENCODED)));
        ClientAuthenticationProperties $this$tokenRequestHeaders_u24lambda_u245_u24lambda_u244 = clientProperties.getAuthentication();
        boolean bl2 = false;
        if (Intrinsics.areEqual((Object)ClientAuthenticationMethod.CLIENT_SECRET_BASIC, (Object)$this$tokenRequestHeaders_u24lambda_u245_u24lambda_u244.getClientAuthMethod())) {
            String string = $this$tokenRequestHeaders_u24lambda_u245_u24lambda_u244.getClientId();
            String string2 = $this$tokenRequestHeaders_u24lambda_u245_u24lambda_u244.getClientSecret();
            Intrinsics.checkNotNull((Object)string2);
            $this$tokenRequestHeaders_u24lambda_u245.put("Authorization", CollectionsKt.listOf((Object)("Basic " + this.basicAuth(string, string2))));
        }
        return hashMap;
    }

    private final Map<String, String> defaultFormParameters(T grantRequest) {
        Object object;
        block5: {
            block4: {
                Map<String, String> map;
                object = grantRequest;
                if (object == null || (object = ((AbstractOAuth2GrantRequest)object).getClientProperties()) == null) break block4;
                T it = object;
                boolean bl = false;
                Map<String, String> $this$defaultFormParameters_u24lambda_u247_u24lambda_u246 = map = this.defaultClientAuthenticationFormParameters(grantRequest);
                boolean bl2 = false;
                String string = ((AbstractOAuth2GrantRequest)grantRequest).getGrantType().getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                $this$defaultFormParameters_u24lambda_u247_u24lambda_u246.put("grant_type", string);
                if (!Intrinsics.areEqual((Object)GrantType.TOKEN_EXCHANGE, (Object)((ClientProperties)it).getGrantType())) {
                    String string2 = String.join((CharSequence)" ", (Iterable<? extends CharSequence>)((ClientProperties)it).getScope());
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"join(...)");
                    $this$defaultFormParameters_u24lambda_u247_u24lambda_u246.put("scope", string2);
                }
                Map<String, String> map2 = map;
                object = map2;
                if (map2 != null) break block5;
            }
            throw new OAuth2ClientException("ClientProperties cannot be null", null, 2, null);
        }
        return object;
    }

    private final Map<String, String> defaultClientAuthenticationFormParameters(T grantRequest) {
        Map map;
        Object object = grantRequest;
        if (object != null && (object = ((AbstractOAuth2GrantRequest)object).getClientProperties()) != null) {
            T it = object;
            boolean bl = false;
            T $this$defaultClientAuthenticationFormParameters_u24lambda_u2411_u24lambda_u2410 = it;
            boolean bl2 = false;
            ClientAuthenticationMethod clientAuthenticationMethod = ((ClientProperties)$this$defaultClientAuthenticationFormParameters_u24lambda_u2411_u24lambda_u2410).getAuthentication().getClientAuthMethod();
            if (Intrinsics.areEqual((Object)clientAuthenticationMethod, (Object)ClientAuthenticationMethod.CLIENT_SECRET_POST)) {
                LinkedHashMap<String, String> linkedHashMap;
                LinkedHashMap<String, String> $this$defaultClientAuthenticationFormParameters_u24lambda_u2411_u24lambda_u2410_u24lambda_u248 = linkedHashMap = new LinkedHashMap<String, String>();
                boolean bl3 = false;
                $this$defaultClientAuthenticationFormParameters_u24lambda_u2411_u24lambda_u2410_u24lambda_u248.put("client_id", ((ClientProperties)$this$defaultClientAuthenticationFormParameters_u24lambda_u2411_u24lambda_u2410).getAuthentication().getClientId());
                String string = ((ClientProperties)$this$defaultClientAuthenticationFormParameters_u24lambda_u2411_u24lambda_u2410).getAuthentication().getClientSecret();
                Intrinsics.checkNotNull((Object)string);
                $this$defaultClientAuthenticationFormParameters_u24lambda_u2411_u24lambda_u2410_u24lambda_u248.put("client_secret", string);
                map = linkedHashMap;
            } else if (Intrinsics.areEqual((Object)clientAuthenticationMethod, (Object)ClientAuthenticationMethod.PRIVATE_KEY_JWT)) {
                LinkedHashMap<String, String> linkedHashMap;
                LinkedHashMap<String, String> $this$defaultClientAuthenticationFormParameters_u24lambda_u2411_u24lambda_u2410_u24lambda_u249 = linkedHashMap = new LinkedHashMap<String, String>();
                boolean bl4 = false;
                $this$defaultClientAuthenticationFormParameters_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.put("client_id", ((ClientProperties)$this$defaultClientAuthenticationFormParameters_u24lambda_u2411_u24lambda_u2410).getAuthentication().getClientId());
                $this$defaultClientAuthenticationFormParameters_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.put("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
                $this$defaultClientAuthenticationFormParameters_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.put("client_assertion", new ClientAssertion(((ClientProperties)$this$defaultClientAuthenticationFormParameters_u24lambda_u2411_u24lambda_u2410).getTokenEndpointUrl(), ((ClientProperties)$this$defaultClientAuthenticationFormParameters_u24lambda_u2411_u24lambda_u2410).getAuthentication()).assertion());
                map = linkedHashMap;
            } else {
                map = new LinkedHashMap();
            }
        } else {
            throw new OAuth2ClientException("ClientProperties cannot be null", null, 2, null);
        }
        return map;
    }

    private final String basicAuth(String username, String password) {
        CharsetEncoder $this$basicAuth_u24lambda_u2412 = StandardCharsets.UTF_8.newEncoder();
        boolean bl = false;
        if (!$this$basicAuth_u24lambda_u2412.canEncode(username) || !$this$basicAuth_u24lambda_u2412.canEncode(password)) {
            throw new IllegalArgumentException("Username or password contains characters that cannot be encoded to " + StandardCharsets.UTF_8.displayName());
        }
        Base64.Encoder encoder = Base64.getEncoder();
        Object object = username + ":" + password;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = ((String)object).getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] byArray2 = encoder.encode(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"encode(...)");
        byte[] byArray3 = byArray2;
        Charset charset2 = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
        object = charset2;
        return new String(byArray3, (Charset)object);
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + " [oAuth2HttpClient=" + this.oAuth2HttpClient + "]";
    }
}

