/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.core;

import com.nimbusds.jose.util.DefaultResourceRetriever;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import no.nav.security.token.support.client.core.ClientAuthenticationProperties;
import no.nav.security.token.support.client.core.OAuth2ClientException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0003\u001f !BW\b\u0007\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u001d\u001a\u00020\u001eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0015\"\u0004\b\u0019\u0010\u001aR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lno/nav/security/token/support/client/core/ClientProperties;", "", "tokenEndpointUrl", "Ljava/net/URI;", "wellKnownUrl", "grantType", "Lcom/nimbusds/oauth2/sdk/GrantType;", "scope", "", "", "authentication", "Lno/nav/security/token/support/client/core/ClientAuthenticationProperties;", "resourceUrl", "tokenExchange", "Lno/nav/security/token/support/client/core/ClientProperties$TokenExchangeProperties;", "(Ljava/net/URI;Ljava/net/URI;Lcom/nimbusds/oauth2/sdk/GrantType;Ljava/util/List;Lno/nav/security/token/support/client/core/ClientAuthenticationProperties;Ljava/net/URI;Lno/nav/security/token/support/client/core/ClientProperties$TokenExchangeProperties;)V", "getAuthentication", "()Lno/nav/security/token/support/client/core/ClientAuthenticationProperties;", "getGrantType", "()Lcom/nimbusds/oauth2/sdk/GrantType;", "getResourceUrl", "()Ljava/net/URI;", "getScope", "()Ljava/util/List;", "getTokenEndpointUrl", "setTokenEndpointUrl", "(Ljava/net/URI;)V", "getTokenExchange", "()Lno/nav/security/token/support/client/core/ClientProperties$TokenExchangeProperties;", "toBuilder", "Lno/nav/security/token/support/client/core/ClientProperties$ClientPropertiesBuilder;", "ClientPropertiesBuilder", "Companion", "TokenExchangeProperties", "token-client-core"})
@SourceDebugExtension(value={"SMAP\nClientProperties.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientProperties.kt\nno/nav/security/token/support/client/core/ClientProperties\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public final class ClientProperties {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private URI tokenEndpointUrl;
    @Nullable
    private final URI wellKnownUrl;
    @NotNull
    private final GrantType grantType;
    @NotNull
    private final List<String> scope;
    @NotNull
    private final ClientAuthenticationProperties authentication;
    @Nullable
    private final URI resourceUrl;
    @Nullable
    private final TokenExchangeProperties tokenExchange;
    @NotNull
    private static final List<GrantType> GRANT_TYPES;

    @JvmOverloads
    public ClientProperties(@Nullable URI tokenEndpointUrl, @Nullable URI wellKnownUrl, @NotNull GrantType grantType, @NotNull List<String> scope, @NotNull ClientAuthenticationProperties authentication, @Nullable URI resourceUrl, @Nullable TokenExchangeProperties tokenExchange) {
        Intrinsics.checkNotNullParameter((Object)grantType, (String)"grantType");
        Intrinsics.checkNotNullParameter(scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
        this.tokenEndpointUrl = tokenEndpointUrl;
        this.wellKnownUrl = wellKnownUrl;
        this.grantType = grantType;
        this.scope = scope;
        this.authentication = authentication;
        this.resourceUrl = resourceUrl;
        this.tokenExchange = tokenExchange;
        URI uRI = this.tokenEndpointUrl;
        if (uRI == null) {
            URI uRI2 = this.wellKnownUrl;
            if (uRI2 == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            uRI = this.tokenEndpointUrl = ClientProperties.Companion.endpointUrlFromMetadata(uRI2);
        }
        if (!GRANT_TYPES.contains(this.grantType)) {
            boolean bl = false;
            String string = "Unsupported grantType " + this.grantType + ", must be one of " + GRANT_TYPES;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ ClientProperties(URI uRI, URI uRI2, GrantType grantType, List list, ClientAuthenticationProperties clientAuthenticationProperties, URI uRI3, TokenExchangeProperties tokenExchangeProperties, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            uRI = null;
        }
        if ((n & 2) != 0) {
            uRI2 = null;
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            uRI3 = null;
        }
        if ((n & 0x40) != 0) {
            tokenExchangeProperties = null;
        }
        this(uRI, uRI2, grantType, list, clientAuthenticationProperties, uRI3, tokenExchangeProperties);
    }

    @Nullable
    public final URI getTokenEndpointUrl() {
        return this.tokenEndpointUrl;
    }

    public final void setTokenEndpointUrl(@Nullable URI uRI) {
        this.tokenEndpointUrl = uRI;
    }

    @NotNull
    public final GrantType getGrantType() {
        return this.grantType;
    }

    @NotNull
    public final List<String> getScope() {
        return this.scope;
    }

    @NotNull
    public final ClientAuthenticationProperties getAuthentication() {
        return this.authentication;
    }

    @Nullable
    public final URI getResourceUrl() {
        return this.resourceUrl;
    }

    @Nullable
    public final TokenExchangeProperties getTokenExchange() {
        return this.tokenExchange;
    }

    @NotNull
    public final ClientPropertiesBuilder toBuilder() {
        return new ClientPropertiesBuilder(this.grantType, this.authentication, null, null, null, null, null, 124, null).tokenEndpointUrl(this.tokenEndpointUrl).wellKnownUrl(this.wellKnownUrl).scope(this.scope).resourceUrl(this.resourceUrl).tokenExchange(this.tokenExchange);
    }

    @JvmOverloads
    public ClientProperties(@Nullable URI tokenEndpointUrl, @Nullable URI wellKnownUrl, @NotNull GrantType grantType, @NotNull List<String> scope, @NotNull ClientAuthenticationProperties authentication, @Nullable URI resourceUrl) {
        Intrinsics.checkNotNullParameter((Object)grantType, (String)"grantType");
        Intrinsics.checkNotNullParameter(scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
        this(tokenEndpointUrl, wellKnownUrl, grantType, scope, authentication, resourceUrl, null, 64, null);
    }

    @JvmOverloads
    public ClientProperties(@Nullable URI tokenEndpointUrl, @Nullable URI wellKnownUrl, @NotNull GrantType grantType, @NotNull List<String> scope, @NotNull ClientAuthenticationProperties authentication) {
        Intrinsics.checkNotNullParameter((Object)grantType, (String)"grantType");
        Intrinsics.checkNotNullParameter(scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
        this(tokenEndpointUrl, wellKnownUrl, grantType, scope, authentication, null, null, 96, null);
    }

    @JvmOverloads
    public ClientProperties(@Nullable URI tokenEndpointUrl, @Nullable URI wellKnownUrl, @NotNull GrantType grantType, @NotNull ClientAuthenticationProperties authentication) {
        Intrinsics.checkNotNullParameter((Object)grantType, (String)"grantType");
        Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
        this(tokenEndpointUrl, wellKnownUrl, grantType, null, authentication, null, null, 104, null);
    }

    @JvmOverloads
    public ClientProperties(@Nullable URI tokenEndpointUrl, @NotNull GrantType grantType, @NotNull ClientAuthenticationProperties authentication) {
        Intrinsics.checkNotNullParameter((Object)grantType, (String)"grantType");
        Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
        this(tokenEndpointUrl, null, grantType, null, authentication, null, null, 106, null);
    }

    @JvmOverloads
    public ClientProperties(@NotNull GrantType grantType, @NotNull ClientAuthenticationProperties authentication) {
        Intrinsics.checkNotNullParameter((Object)grantType, (String)"grantType");
        Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
        this(null, null, grantType, null, authentication, null, null, 107, null);
    }

    @JvmStatic
    @NotNull
    public static final ClientPropertiesBuilder builder(@NotNull GrantType grantType, @NotNull ClientAuthenticationProperties authentication) {
        return Companion.builder(grantType, authentication);
    }

    static {
        Object[] objectArray = new GrantType[]{GrantType.JWT_BEARER, GrantType.CLIENT_CREDENTIALS, GrantType.TOKEN_EXCHANGE};
        GRANT_TYPES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u00002\u00020\u0001BW\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\f\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u0007J\u0014\u0010\t\u001a\u00020\u00002\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u001f\u0010\u0014\u001a\u00020\u00002\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0015\"\u00020\u000b\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0006\u001a\u00020\u00002\b\u0010\u0017\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u0006\u001a\u00020\u00002\b\u0010\u0017\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\r\u001a\u00020\u00002\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\b\u001a\u00020\u00002\b\u0010\u0018\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\b\u001a\u00020\u00002\b\u0010\u0018\u001a\u0004\u0018\u00010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lno/nav/security/token/support/client/core/ClientProperties$ClientPropertiesBuilder;", "", "grantType", "Lcom/nimbusds/oauth2/sdk/GrantType;", "authentication", "Lno/nav/security/token/support/client/core/ClientAuthenticationProperties;", "tokenEndpointUrl", "Ljava/net/URI;", "wellKnownUrl", "scope", "", "", "resourceUrl", "tokenExchange", "Lno/nav/security/token/support/client/core/ClientProperties$TokenExchangeProperties;", "(Lcom/nimbusds/oauth2/sdk/GrantType;Lno/nav/security/token/support/client/core/ClientAuthenticationProperties;Ljava/net/URI;Ljava/net/URI;Ljava/util/List;Ljava/net/URI;Lno/nav/security/token/support/client/core/ClientProperties$TokenExchangeProperties;)V", "getAuthentication", "()Lno/nav/security/token/support/client/core/ClientAuthenticationProperties;", "build", "Lno/nav/security/token/support/client/core/ClientProperties;", "scopes", "", "([Ljava/lang/String;)Lno/nav/security/token/support/client/core/ClientProperties$ClientPropertiesBuilder;", "endpointURI", "wellKnownURI", "token-client-core"})
    @SourceDebugExtension(value={"SMAP\nClientProperties.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientProperties.kt\nno/nav/security/token/support/client/core/ClientProperties$ClientPropertiesBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
    public static final class ClientPropertiesBuilder {
        @NotNull
        private final GrantType grantType;
        @NotNull
        private final ClientAuthenticationProperties authentication;
        @Nullable
        private URI tokenEndpointUrl;
        @Nullable
        private URI wellKnownUrl;
        @NotNull
        private List<String> scope;
        @Nullable
        private URI resourceUrl;
        @Nullable
        private TokenExchangeProperties tokenExchange;

        @JvmOverloads
        public ClientPropertiesBuilder(@NotNull GrantType grantType, @NotNull ClientAuthenticationProperties authentication, @Nullable URI tokenEndpointUrl, @Nullable URI wellKnownUrl, @NotNull List<String> scope, @Nullable URI resourceUrl, @Nullable TokenExchangeProperties tokenExchange) {
            Intrinsics.checkNotNullParameter((Object)grantType, (String)"grantType");
            Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
            Intrinsics.checkNotNullParameter(scope, (String)"scope");
            this.grantType = grantType;
            this.authentication = authentication;
            this.tokenEndpointUrl = tokenEndpointUrl;
            this.wellKnownUrl = wellKnownUrl;
            this.scope = scope;
            this.resourceUrl = resourceUrl;
            this.tokenExchange = tokenExchange;
        }

        public /* synthetic */ ClientPropertiesBuilder(GrantType grantType, ClientAuthenticationProperties clientAuthenticationProperties, URI uRI, URI uRI2, List list, URI uRI3, TokenExchangeProperties tokenExchangeProperties, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                uRI = null;
            }
            if ((n & 8) != 0) {
                uRI2 = null;
            }
            if ((n & 0x10) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n & 0x20) != 0) {
                uRI3 = null;
            }
            if ((n & 0x40) != 0) {
                tokenExchangeProperties = null;
            }
            this(grantType, clientAuthenticationProperties, uRI, uRI2, list, uRI3, tokenExchangeProperties);
        }

        @NotNull
        public final ClientAuthenticationProperties getAuthentication() {
            return this.authentication;
        }

        @NotNull
        public final ClientPropertiesBuilder tokenEndpointUrl(@Nullable String endpointURI) {
            Object object;
            block3: {
                block2: {
                    object = endpointURI;
                    if (object == null) break block2;
                    String it = object;
                    boolean bl = false;
                    ClientPropertiesBuilder clientPropertiesBuilder = this.tokenEndpointUrl(URI.create(it));
                    object = clientPropertiesBuilder;
                    if (clientPropertiesBuilder != null) break block3;
                }
                object = this;
            }
            return object;
        }

        @NotNull
        public final ClientPropertiesBuilder tokenEndpointUrl(@Nullable URI endpointURI) {
            ClientPropertiesBuilder clientPropertiesBuilder;
            ClientPropertiesBuilder it = clientPropertiesBuilder = this;
            boolean bl = false;
            it.tokenEndpointUrl = endpointURI;
            return clientPropertiesBuilder;
        }

        @NotNull
        public final ClientPropertiesBuilder wellKnownUrl(@Nullable String wellKnownURI) {
            Object object;
            block3: {
                block2: {
                    object = wellKnownURI;
                    if (object == null) break block2;
                    String it = object;
                    boolean bl = false;
                    ClientPropertiesBuilder clientPropertiesBuilder = this.wellKnownUrl(URI.create(it));
                    object = clientPropertiesBuilder;
                    if (clientPropertiesBuilder != null) break block3;
                }
                object = this;
            }
            return object;
        }

        @NotNull
        public final ClientPropertiesBuilder wellKnownUrl(@Nullable URI wellKnownURI) {
            ClientPropertiesBuilder clientPropertiesBuilder;
            ClientPropertiesBuilder it = clientPropertiesBuilder = this;
            boolean bl = false;
            it.wellKnownUrl = wellKnownURI;
            return clientPropertiesBuilder;
        }

        @NotNull
        public final ClientPropertiesBuilder scopes(String ... scopes) {
            Intrinsics.checkNotNullParameter((Object)scopes, (String)"scopes");
            return this.scope(ArraysKt.toList((Object[])scopes));
        }

        @NotNull
        public final ClientPropertiesBuilder scope(@NotNull List<String> scope) {
            ClientPropertiesBuilder clientPropertiesBuilder;
            Intrinsics.checkNotNullParameter(scope, (String)"scope");
            ClientPropertiesBuilder it = clientPropertiesBuilder = this;
            boolean bl = false;
            it.scope = scope;
            return clientPropertiesBuilder;
        }

        @NotNull
        public final ClientPropertiesBuilder resourceUrl(@Nullable URI resourceUrl) {
            ClientPropertiesBuilder clientPropertiesBuilder;
            ClientPropertiesBuilder it = clientPropertiesBuilder = this;
            boolean bl = false;
            it.resourceUrl = resourceUrl;
            return clientPropertiesBuilder;
        }

        @NotNull
        public final ClientPropertiesBuilder tokenExchange(@Nullable TokenExchangeProperties tokenExchange) {
            ClientPropertiesBuilder clientPropertiesBuilder;
            ClientPropertiesBuilder it = clientPropertiesBuilder = this;
            boolean bl = false;
            it.tokenExchange = tokenExchange;
            return clientPropertiesBuilder;
        }

        @NotNull
        public final ClientProperties build() {
            return new ClientProperties(this.tokenEndpointUrl, this.wellKnownUrl, this.grantType, this.scope, this.authentication, this.resourceUrl, this.tokenExchange);
        }

        @JvmOverloads
        public ClientPropertiesBuilder(@NotNull GrantType grantType, @NotNull ClientAuthenticationProperties authentication, @Nullable URI tokenEndpointUrl, @Nullable URI wellKnownUrl, @NotNull List<String> scope, @Nullable URI resourceUrl) {
            Intrinsics.checkNotNullParameter((Object)grantType, (String)"grantType");
            Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
            Intrinsics.checkNotNullParameter(scope, (String)"scope");
            this(grantType, authentication, tokenEndpointUrl, wellKnownUrl, scope, resourceUrl, null, 64, null);
        }

        @JvmOverloads
        public ClientPropertiesBuilder(@NotNull GrantType grantType, @NotNull ClientAuthenticationProperties authentication, @Nullable URI tokenEndpointUrl, @Nullable URI wellKnownUrl, @NotNull List<String> scope) {
            Intrinsics.checkNotNullParameter((Object)grantType, (String)"grantType");
            Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
            Intrinsics.checkNotNullParameter(scope, (String)"scope");
            this(grantType, authentication, tokenEndpointUrl, wellKnownUrl, scope, null, null, 96, null);
        }

        @JvmOverloads
        public ClientPropertiesBuilder(@NotNull GrantType grantType, @NotNull ClientAuthenticationProperties authentication, @Nullable URI tokenEndpointUrl, @Nullable URI wellKnownUrl) {
            Intrinsics.checkNotNullParameter((Object)grantType, (String)"grantType");
            Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
            this(grantType, authentication, tokenEndpointUrl, wellKnownUrl, null, null, null, 112, null);
        }

        @JvmOverloads
        public ClientPropertiesBuilder(@NotNull GrantType grantType, @NotNull ClientAuthenticationProperties authentication, @Nullable URI tokenEndpointUrl) {
            Intrinsics.checkNotNullParameter((Object)grantType, (String)"grantType");
            Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
            this(grantType, authentication, tokenEndpointUrl, null, null, null, null, 120, null);
        }

        @JvmOverloads
        public ClientPropertiesBuilder(@NotNull GrantType grantType, @NotNull ClientAuthenticationProperties authentication) {
            Intrinsics.checkNotNullParameter((Object)grantType, (String)"grantType");
            Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
            this(grantType, authentication, null, null, null, null, null, 124, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lno/nav/security/token/support/client/core/ClientProperties$Companion;", "", "()V", "GRANT_TYPES", "", "Lcom/nimbusds/oauth2/sdk/GrantType;", "kotlin.jvm.PlatformType", "builder", "Lno/nav/security/token/support/client/core/ClientProperties$ClientPropertiesBuilder;", "grantType", "authentication", "Lno/nav/security/token/support/client/core/ClientAuthenticationProperties;", "endpointUrlFromMetadata", "Ljava/net/URI;", "wellKnown", "token-client-core"})
    @SourceDebugExtension(value={"SMAP\nClientProperties.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientProperties.kt\nno/nav/security/token/support/client/core/ClientProperties$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ClientPropertiesBuilder builder(@NotNull GrantType grantType, @NotNull ClientAuthenticationProperties authentication) {
            Intrinsics.checkNotNullParameter((Object)grantType, (String)"grantType");
            Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
            return new ClientPropertiesBuilder(grantType, authentication, null, null, null, null, null, 124, null);
        }

        private final URI endpointUrlFromMetadata(URI wellKnown) {
            Object $this$endpointUrlFromMetadata_u24lambda_u241;
            Object object = this;
            try {
                URI uRI;
                $this$endpointUrlFromMetadata_u24lambda_u241 = object;
                boolean bl = false;
                URI uRI2 = wellKnown;
                if (uRI2 != null) {
                    URI it = uRI2;
                    boolean bl2 = false;
                    v1 = AuthorizationServerMetadata.parse((String)new DefaultResourceRetriever().retrieveResource(wellKnown.toURL()).getContent()).getTokenEndpointURI();
                } else {
                    v1 = uRI = null;
                }
                if (uRI == null) {
                    throw new OAuth2ClientException("Well-known url cannot be null, please check your configuration", null, 2, null);
                }
                $this$endpointUrlFromMetadata_u24lambda_u241 = Result.constructor-impl(uRI);
            }
            catch (Throwable bl) {
                $this$endpointUrlFromMetadata_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$endpointUrlFromMetadata_u24lambda_u241;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable it = throwable;
                boolean bl = false;
                Throwable throwable2 = it;
                if (throwable2 instanceof ParseException) {
                    throw new OAuth2ClientException("Unable to parse response from " + wellKnown, it);
                }
                if (throwable2 instanceof IOException) {
                    throw new OAuth2ClientException("Unable to read from " + wellKnown, it);
                }
                if (throwable2 instanceof OAuth2ClientException) {
                    throw it;
                }
                throw new OAuth2ClientException("Unexpected error reading from " + wellKnown, it);
            }
            return (URI)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0007\"\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lno/nav/security/token/support/client/core/ClientProperties$TokenExchangeProperties;", "", "audience", "", "resource", "(Ljava/lang/String;Ljava/lang/String;)V", "getAudience", "()Ljava/lang/String;", "getResource", "setResource", "(Ljava/lang/String;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "token-client-core"})
    public static final class TokenExchangeProperties {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String audience;
        @Nullable
        private String resource;
        @NotNull
        public static final String SUBJECT_TOKEN_TYPE_VALUE = "urn:ietf:params:oauth:token-type:jwt";

        @JvmOverloads
        public TokenExchangeProperties(@NotNull String audience, @Nullable String resource) {
            Intrinsics.checkNotNullParameter((Object)audience, (String)"audience");
            this.audience = audience;
            this.resource = resource;
        }

        public /* synthetic */ TokenExchangeProperties(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            this(string, string2);
        }

        @NotNull
        public final String getAudience() {
            return this.audience;
        }

        @Nullable
        public final String getResource() {
            return this.resource;
        }

        public final void setResource(@Nullable String string) {
            this.resource = string;
        }

        @NotNull
        public final String component1() {
            return this.audience;
        }

        @Nullable
        public final String component2() {
            return this.resource;
        }

        @NotNull
        public final TokenExchangeProperties copy(@NotNull String audience, @Nullable String resource) {
            Intrinsics.checkNotNullParameter((Object)audience, (String)"audience");
            return new TokenExchangeProperties(audience, resource);
        }

        public static /* synthetic */ TokenExchangeProperties copy$default(TokenExchangeProperties tokenExchangeProperties, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = tokenExchangeProperties.audience;
            }
            if ((n & 2) != 0) {
                string2 = tokenExchangeProperties.resource;
            }
            return tokenExchangeProperties.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "TokenExchangeProperties(audience=" + this.audience + ", resource=" + this.resource + ")";
        }

        public int hashCode() {
            int result = this.audience.hashCode();
            result = result * 31 + (this.resource == null ? 0 : this.resource.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TokenExchangeProperties)) {
                return false;
            }
            TokenExchangeProperties tokenExchangeProperties = (TokenExchangeProperties)other;
            if (!Intrinsics.areEqual((Object)this.audience, (Object)tokenExchangeProperties.audience)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.resource, (Object)tokenExchangeProperties.resource);
        }

        @JvmOverloads
        public TokenExchangeProperties(@NotNull String audience) {
            Intrinsics.checkNotNullParameter((Object)audience, (String)"audience");
            this(audience, null, 2, null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lno/nav/security/token/support/client/core/ClientProperties$TokenExchangeProperties$Companion;", "", "()V", "SUBJECT_TOKEN_TYPE_VALUE", "", "token-client-core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

