/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.core.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import no.nav.security.token.support.client.core.OAuth2ClientException;
import no.nav.security.token.support.client.core.http.OAuth2HttpClient;
import no.nav.security.token.support.client.core.http.OAuth2HttpRequest;
import no.nav.security.token.support.client.core.http.SimpleOAuth2HttpClient;
import no.nav.security.token.support.client.core.oauth2.OAuth2AccessTokenResponse;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0014\u0010\u0007\u001a\u00020\b*\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\t\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J0\u0010\f\u001a&\u0012\f\u0012\n \r*\u0004\u0018\u00010\u000b0\u000b \r*\u0012\u0012\f\u0012\n \r*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\n0\n*\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u000b*\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lno/nav/security/token/support/client/core/http/SimpleOAuth2HttpClient;", "Lno/nav/security/token/support/client/core/http/OAuth2HttpClient;", "()V", "post", "Lno/nav/security/token/support/client/core/oauth2/OAuth2AccessTokenResponse;", "req", "Lno/nav/security/token/support/client/core/http/OAuth2HttpRequest;", "configureRequest", "Ljava/net/http/HttpRequest$Builder;", "processResponse", "Ljava/net/http/HttpResponse;", "", "sendRequest", "kotlin.jvm.PlatformType", "Ljava/net/http/HttpRequest;", "toUrlEncodedString", "", "Companion", "token-client-core"})
@SourceDebugExtension(value={"SMAP\nSimpleOAuth2HttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleOAuth2HttpClient.kt\nno/nav/security/token/support/client/core/http/SimpleOAuth2HttpClient\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,42:1\n215#2:43\n216#2:46\n1855#3,2:44\n50#4:47\n43#4:48\n*S KotlinDebug\n*F\n+ 1 SimpleOAuth2HttpClient.kt\nno/nav/security/token/support/client/core/http/SimpleOAuth2HttpClient\n*L\n25#1:43\n25#1:46\n25#1:44,2\n34#1:47\n34#1:48\n*E\n"})
public final class SimpleOAuth2HttpClient
implements OAuth2HttpClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final ObjectMapper MAPPER = ExtensionsKt.jacksonObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    @Override
    @NotNull
    public OAuth2AccessTokenResponse post(@NotNull OAuth2HttpRequest req) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        HttpRequest.Builder builder = HttpRequest.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder(...)");
        HttpRequest httpRequest = this.configureRequest(builder, req).build();
        Intrinsics.checkNotNullExpressionValue((Object)httpRequest, (String)"build(...)");
        HttpResponse<String> httpResponse = this.sendRequest(httpRequest);
        Intrinsics.checkNotNullExpressionValue(httpResponse, (String)"sendRequest(...)");
        return this.processResponse(httpResponse);
    }

    private final HttpRequest.Builder configureRequest(HttpRequest.Builder $this$configureRequest, OAuth2HttpRequest req) {
        Map<String, List<String>> $this$forEach$iv = req.getOAuth2HttpHeaders().getHeaders();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, List<String>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<String>> element$iv;
            Map.Entry<String, List<String>> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            List<String> values = entry.getValue();
            Iterable $this$forEach$iv2 = values;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl2 = false;
                $this$configureRequest.header(key, it);
            }
        }
        $this$configureRequest.uri(req.getTokenEndpointUrl());
        $this$configureRequest.POST(HttpRequest.BodyPublishers.ofString(this.toUrlEncodedString(req.getFormParameters())));
        return $this$configureRequest;
    }

    private final HttpResponse<String> sendRequest(HttpRequest $this$sendRequest) {
        return HttpClient.newHttpClient().send($this$sendRequest, HttpResponse.BodyHandlers.ofString());
    }

    /*
     * WARNING - void declaration
     */
    private final OAuth2AccessTokenResponse processResponse(HttpResponse<String> $this$processResponse) {
        void $this$readValue$iv;
        int n = $this$processResponse.statusCode();
        if (!(200 <= n ? n < 300 : false)) {
            throw new OAuth2ClientException("Error response from token endpoint: " + $this$processResponse.statusCode() + " " + $this$processResponse.body(), null, 2, null);
        }
        ObjectMapper objectMapper = MAPPER;
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"MAPPER");
        ObjectMapper objectMapper2 = objectMapper;
        String string = $this$processResponse.body();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"body(...)");
        String content$iv = string;
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        return (OAuth2AccessTokenResponse)$this$readValue$iv.readValue(content$iv, (TypeReference)new TypeReference<OAuth2AccessTokenResponse>(){});
    }

    private final String toUrlEncodedString(Map<String, String> $this$toUrlEncodedString) {
        return CollectionsKt.joinToString$default((Iterable)$this$toUrlEncodedString.entrySet(), (CharSequence)"&", null, null, (int)0, null, (Function1)toUrlEncodedString.1.INSTANCE, (int)30, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lno/nav/security/token/support/client/core/http/SimpleOAuth2HttpClient$Companion;", "", "()V", "MAPPER", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "token-client-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

