/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.core;

import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import no.nav.security.token.support.client.core.ClientAuthenticationPropertiesBuilder;
import no.nav.security.token.support.client.core.jwk.JwkFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B;\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lno/nav/security/token/support/client/core/ClientAuthenticationProperties;", "", "clientId", "", "clientAuthMethod", "Lcom/nimbusds/oauth2/sdk/auth/ClientAuthenticationMethod;", "clientSecret", "clientJwk", "clientRsaKey", "Lcom/nimbusds/jose/jwk/RSAKey;", "<init>", "(Ljava/lang/String;Lcom/nimbusds/oauth2/sdk/auth/ClientAuthenticationMethod;Ljava/lang/String;Ljava/lang/String;Lcom/nimbusds/jose/jwk/RSAKey;)V", "getClientId", "()Ljava/lang/String;", "getClientAuthMethod", "()Lcom/nimbusds/oauth2/sdk/auth/ClientAuthenticationMethod;", "getClientSecret", "getClientJwk", "getClientRsaKey", "()Lcom/nimbusds/jose/jwk/RSAKey;", "Companion", "token-client-core"})
@SourceDebugExtension(value={"SMAP\nClientAuthenticationProperties.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientAuthenticationProperties.kt\nno/nav/security/token/support/client/core/ClientAuthenticationProperties\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,47:1\n1#2:48\n*E\n"})
public final class ClientAuthenticationProperties {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String clientId;
    @NotNull
    private final ClientAuthenticationMethod clientAuthMethod;
    @Nullable
    private final String clientSecret;
    @Nullable
    private final String clientJwk;
    @Nullable
    private final RSAKey clientRsaKey;
    @NotNull
    private static final List<ClientAuthenticationMethod> CLIENT_AUTH_METHODS;

    @JvmOverloads
    public ClientAuthenticationProperties(@NotNull String clientId, @NotNull ClientAuthenticationMethod clientAuthMethod, @Nullable String clientSecret, @Nullable String clientJwk, @Nullable RSAKey clientRsaKey) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)clientAuthMethod, (String)"clientAuthMethod");
        this.clientId = clientId;
        this.clientAuthMethod = clientAuthMethod;
        this.clientSecret = clientSecret;
        this.clientJwk = clientJwk;
        this.clientRsaKey = clientRsaKey;
        if (!CLIENT_AUTH_METHODS.contains(this.clientAuthMethod)) {
            boolean $i$a$-require-ClientAuthenticationProperties$22 = false;
            String $i$a$-require-ClientAuthenticationProperties$22 = "Unsupported authentication method " + this.clientAuthMethod + ", must be one of " + CLIENT_AUTH_METHODS;
            throw new IllegalArgumentException($i$a$-require-ClientAuthenticationProperties$22.toString());
        }
        Object[] objectArray = new ClientAuthenticationMethod[]{ClientAuthenticationMethod.CLIENT_SECRET_BASIC, ClientAuthenticationMethod.CLIENT_SECRET_POST};
        if (CollectionsKt.listOf((Object[])objectArray).contains(this.clientAuthMethod) && this.clientSecret == null) {
            boolean $i$a$-requireNotNull-ClientAuthenticationProperties$42 = false;
            String $i$a$-requireNotNull-ClientAuthenticationProperties$42 = "Client secret must be set for authentication method " + this.clientAuthMethod;
            throw new IllegalArgumentException($i$a$-requireNotNull-ClientAuthenticationProperties$42.toString());
        }
        if (ClientAuthenticationMethod.PRIVATE_KEY_JWT.equals((Object)this.clientAuthMethod)) {
            if (this.clientJwk == null) {
                boolean bl = false;
                String string = "Client private key must be set for authentication method " + this.clientAuthMethod;
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    public /* synthetic */ ClientAuthenticationProperties(String string, ClientAuthenticationMethod clientAuthenticationMethod, String string2, String string3, RSAKey rSAKey, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string3 = null;
        }
        if ((n & 0x10) != 0) {
            rSAKey = ClientAuthenticationProperties.Companion.loadKey(string3);
        }
        this(string, clientAuthenticationMethod, string2, string3, rSAKey);
    }

    @NotNull
    public final String getClientId() {
        return this.clientId;
    }

    @NotNull
    public final ClientAuthenticationMethod getClientAuthMethod() {
        return this.clientAuthMethod;
    }

    @Nullable
    public final String getClientSecret() {
        return this.clientSecret;
    }

    @Nullable
    public final String getClientJwk() {
        return this.clientJwk;
    }

    @Nullable
    public final RSAKey getClientRsaKey() {
        return this.clientRsaKey;
    }

    @JvmOverloads
    public ClientAuthenticationProperties(@NotNull String clientId, @NotNull ClientAuthenticationMethod clientAuthMethod, @Nullable String clientSecret, @Nullable String clientJwk) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)clientAuthMethod, (String)"clientAuthMethod");
        this(clientId, clientAuthMethod, clientSecret, clientJwk, null, 16, null);
    }

    @JvmOverloads
    public ClientAuthenticationProperties(@NotNull String clientId, @NotNull ClientAuthenticationMethod clientAuthMethod, @Nullable String clientSecret) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)clientAuthMethod, (String)"clientAuthMethod");
        this(clientId, clientAuthMethod, clientSecret, null, null, 24, null);
    }

    @JvmStatic
    @NotNull
    public static final ClientAuthenticationPropertiesBuilder builder(@NotNull String clientId, @NotNull ClientAuthenticationMethod clientAuthMethod) {
        return Companion.builder(clientId, clientAuthMethod);
    }

    static {
        Object[] objectArray = new ClientAuthenticationMethod[]{ClientAuthenticationMethod.CLIENT_SECRET_BASIC, ClientAuthenticationMethod.CLIENT_SECRET_POST, ClientAuthenticationMethod.PRIVATE_KEY_JWT};
        CLIENT_AUTH_METHODS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0007J\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000bH\u0002R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lno/nav/security/token/support/client/core/ClientAuthenticationProperties$Companion;", "", "<init>", "()V", "CLIENT_AUTH_METHODS", "", "Lcom/nimbusds/oauth2/sdk/auth/ClientAuthenticationMethod;", "kotlin.jvm.PlatformType", "builder", "Lno/nav/security/token/support/client/core/ClientAuthenticationPropertiesBuilder;", "clientId", "", "clientAuthMethod", "loadKey", "Lcom/nimbusds/jose/jwk/RSAKey;", "clientJwk", "token-client-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ClientAuthenticationPropertiesBuilder builder(@NotNull String clientId, @NotNull ClientAuthenticationMethod clientAuthMethod) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)clientAuthMethod, (String)"clientAuthMethod");
            return new ClientAuthenticationPropertiesBuilder(clientId, clientAuthMethod, null, null, 12, null);
        }

        private final RSAKey loadKey(String clientJwk) {
            RSAKey rSAKey;
            String string = clientJwk;
            if (string != null) {
                String it = string;
                boolean bl = false;
                rSAKey = StringsKt.startsWith$default((String)it, (String)"{", (boolean)false, (int)2, null) ? JwkFactory.fromJson(it) : JwkFactory.fromJsonFile(it);
            } else {
                rSAKey = null;
            }
            return rSAKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

