/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.core.auth;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.net.URI;
import java.time.Instant;
import java.util.Date;
import java.util.UUID;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.token.support.client.core.ClientAuthenticationProperties;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\n\u0010\u000eJ\u0013\u0010\u000f\u001a\n \u0010*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0005H\u0007J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lno/nav/security/token/support/client/core/auth/ClientAssertion;", "", "tokenEndpointUrl", "Ljava/net/URI;", "clientId", "", "rsaKey", "Lcom/nimbusds/jose/jwk/RSAKey;", "expiryInSeconds", "", "<init>", "(Ljava/net/URI;Ljava/lang/String;Lcom/nimbusds/jose/jwk/RSAKey;I)V", "auth", "Lno/nav/security/token/support/client/core/ClientAuthenticationProperties;", "(Ljava/net/URI;Lno/nav/security/token/support/client/core/ClientAuthenticationProperties;)V", "assertion", "kotlin.jvm.PlatformType", "()Ljava/lang/String;", "assertionType", "createSignedJWT", "Lcom/nimbusds/jwt/SignedJWT;", "rsaJwk", "claimsSet", "Lcom/nimbusds/jwt/JWTClaimsSet;", "Companion", "token-client-core"})
public final class ClientAssertion {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final URI tokenEndpointUrl;
    @NotNull
    private final String clientId;
    @NotNull
    private final RSAKey rsaKey;
    private final int expiryInSeconds;
    private static final int EXPIRY_IN_SECONDS = 60;

    public ClientAssertion(@NotNull URI tokenEndpointUrl, @NotNull String clientId, @NotNull RSAKey rsaKey, int expiryInSeconds) {
        Intrinsics.checkNotNullParameter((Object)tokenEndpointUrl, (String)"tokenEndpointUrl");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)rsaKey, (String)"rsaKey");
        this.tokenEndpointUrl = tokenEndpointUrl;
        this.clientId = clientId;
        this.rsaKey = rsaKey;
        this.expiryInSeconds = expiryInSeconds;
    }

    public ClientAssertion(@NotNull URI tokenEndpointUrl, @NotNull ClientAuthenticationProperties auth) {
        Intrinsics.checkNotNullParameter((Object)tokenEndpointUrl, (String)"tokenEndpointUrl");
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        String string = auth.getClientId();
        RSAKey rSAKey = auth.getClientRsaKey();
        Intrinsics.checkNotNull((Object)rSAKey);
        this(tokenEndpointUrl, string, rSAKey, 60);
    }

    public final String assertion() {
        Instant $this$assertion_u24lambda_u240 = Instant.now();
        boolean bl = false;
        JWTClaimsSet jWTClaimsSet = new JWTClaimsSet.Builder().audience(String.valueOf(this.tokenEndpointUrl)).expirationTime(Date.from($this$assertion_u24lambda_u240.plusSeconds(this.expiryInSeconds))).issuer(this.clientId).subject(this.clientId).claim("jti", (Object)String.valueOf(UUID.randomUUID())).notBeforeTime(Date.from($this$assertion_u24lambda_u240)).issueTime(Date.from($this$assertion_u24lambda_u240)).build();
        Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet, (String)"build(...)");
        return this.createSignedJWT(this.rsaKey, jWTClaimsSet).serialize();
    }

    @Deprecated(message="Use com.nimbusds.oauth2.sdk.auth.JWTAuthentication instead", replaceWith=@ReplaceWith(expression="JWTAuthentication.CLIENT_ASSERTION_TYPE", imports={}), level=DeprecationLevel.WARNING)
    @NotNull
    public final String assertionType() {
        return "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";
    }

    private final SignedJWT createSignedJWT(RSAKey rsaJwk, JWTClaimsSet claimsSet) {
        Object $this$createSignedJWT_u24lambda_u242;
        Object object = this;
        try {
            SignedJWT signedJWT;
            $this$createSignedJWT_u24lambda_u242 = object;
            boolean bl = false;
            SignedJWT $this$createSignedJWT_u24lambda_u242_u24lambda_u241 = signedJWT = new SignedJWT(new JWSHeader.Builder(JWSAlgorithm.RS256).keyID(rsaJwk.getKeyID()).type(JOSEObjectType.JWT).build(), claimsSet);
            boolean bl2 = false;
            $this$createSignedJWT_u24lambda_u242_u24lambda_u241.sign((JWSSigner)new RSASSASigner(rsaJwk.toPrivateKey()));
            $this$createSignedJWT_u24lambda_u242 = Result.constructor-impl((Object)signedJWT);
        }
        catch (Throwable bl) {
            $this$createSignedJWT_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$createSignedJWT_u24lambda_u242;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            throw new RuntimeException(it);
        }
        return (SignedJWT)object;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lno/nav/security/token/support/client/core/auth/ClientAssertion$Companion;", "", "<init>", "()V", "EXPIRY_IN_SECONDS", "", "token-client-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

