/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.core.oauth2;

import com.nimbusds.oauth2.sdk.GrantType;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.token.support.client.core.ClientProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lno/nav/security/token/support/client/core/oauth2/AbstractOAuth2GrantRequest;", "", "grantType", "Lcom/nimbusds/oauth2/sdk/GrantType;", "clientProperties", "Lno/nav/security/token/support/client/core/ClientProperties;", "<init>", "(Lcom/nimbusds/oauth2/sdk/GrantType;Lno/nav/security/token/support/client/core/ClientProperties;)V", "getGrantType", "()Lcom/nimbusds/oauth2/sdk/GrantType;", "getClientProperties", "()Lno/nav/security/token/support/client/core/ClientProperties;", "equals", "", "other", "scopes", "", "hashCode", "", "toString", "token-client-core"})
public abstract class AbstractOAuth2GrantRequest {
    @NotNull
    private final GrantType grantType;
    @NotNull
    private final ClientProperties clientProperties;

    public AbstractOAuth2GrantRequest(@NotNull GrantType grantType, @NotNull ClientProperties clientProperties) {
        Intrinsics.checkNotNullParameter((Object)grantType, (String)"grantType");
        Intrinsics.checkNotNullParameter((Object)clientProperties, (String)"clientProperties");
        this.grantType = grantType;
        this.clientProperties = clientProperties;
    }

    @NotNull
    public final GrantType getGrantType() {
        return this.grantType;
    }

    @NotNull
    public final ClientProperties getClientProperties() {
        return this.clientProperties;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        AbstractOAuth2GrantRequest that = (AbstractOAuth2GrantRequest)other;
        return Intrinsics.areEqual((Object)this.grantType, (Object)that.grantType) && Intrinsics.areEqual((Object)this.clientProperties, (Object)that.clientProperties);
    }

    @NotNull
    public final String scopes() {
        return CollectionsKt.joinToString$default((Iterable)this.clientProperties.getScope(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.grantType, this.clientProperties};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + " [oAuth2GrantType=" + this.grantType + ", clientProperties=" + this.clientProperties + "]";
    }
}

