/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.core.http;

import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import no.nav.security.token.support.client.core.http.OAuth2HttpHeaders;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u0000 \u00122\u00020\u0001:\u0002\u0011\u0012B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lno/nav/security/token/support/client/core/http/OAuth2HttpRequest;", "", "tokenEndpointUrl", "Ljava/net/URI;", "oAuth2HttpHeaders", "Lno/nav/security/token/support/client/core/http/OAuth2HttpHeaders;", "formParameters", "", "", "<init>", "(Ljava/net/URI;Lno/nav/security/token/support/client/core/http/OAuth2HttpHeaders;Ljava/util/Map;)V", "getTokenEndpointUrl", "()Ljava/net/URI;", "getOAuth2HttpHeaders", "()Lno/nav/security/token/support/client/core/http/OAuth2HttpHeaders;", "getFormParameters", "()Ljava/util/Map;", "OAuth2HttpRequestBuilder", "Companion", "token-client-core"})
public final class OAuth2HttpRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final URI tokenEndpointUrl;
    @NotNull
    private final OAuth2HttpHeaders oAuth2HttpHeaders;
    @NotNull
    private final Map<String, String> formParameters;

    public OAuth2HttpRequest(@NotNull URI tokenEndpointUrl, @NotNull OAuth2HttpHeaders oAuth2HttpHeaders, @NotNull Map<String, String> formParameters) {
        Intrinsics.checkNotNullParameter((Object)tokenEndpointUrl, (String)"tokenEndpointUrl");
        Intrinsics.checkNotNullParameter((Object)oAuth2HttpHeaders, (String)"oAuth2HttpHeaders");
        Intrinsics.checkNotNullParameter(formParameters, (String)"formParameters");
        this.tokenEndpointUrl = tokenEndpointUrl;
        this.oAuth2HttpHeaders = oAuth2HttpHeaders;
        this.formParameters = formParameters;
    }

    public /* synthetic */ OAuth2HttpRequest(URI uRI, OAuth2HttpHeaders oAuth2HttpHeaders, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            oAuth2HttpHeaders = OAuth2HttpHeaders.NONE;
        }
        this(uRI, oAuth2HttpHeaders, map);
    }

    @NotNull
    public final URI getTokenEndpointUrl() {
        return this.tokenEndpointUrl;
    }

    @NotNull
    public final OAuth2HttpHeaders getOAuth2HttpHeaders() {
        return this.oAuth2HttpHeaders;
    }

    @NotNull
    public final Map<String, String> getFormParameters() {
        return this.formParameters;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lno/nav/security/token/support/client/core/http/OAuth2HttpRequest$Companion;", "", "<init>", "()V", "builder", "Lno/nav/security/token/support/client/core/http/OAuth2HttpRequest$OAuth2HttpRequestBuilder;", "tokenEndpointUrl", "Ljava/net/URI;", "token-client-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OAuth2HttpRequestBuilder builder(@NotNull URI tokenEndpointUrl) {
            Intrinsics.checkNotNullParameter((Object)tokenEndpointUrl, (String)"tokenEndpointUrl");
            return new OAuth2HttpRequestBuilder(tokenEndpointUrl, null, null, 6, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B1\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u0016\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bJ\u001a\u0010\u0006\u001a\u00020\u00002\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lno/nav/security/token/support/client/core/http/OAuth2HttpRequest$OAuth2HttpRequestBuilder;", "", "tokenEndpointUrl", "Ljava/net/URI;", "oAuth2HttpHeaders", "Lno/nav/security/token/support/client/core/http/OAuth2HttpHeaders;", "formParameters", "", "", "<init>", "(Ljava/net/URI;Lno/nav/security/token/support/client/core/http/OAuth2HttpHeaders;Ljava/util/Map;)V", "formParameter", "key", "value", "entries", "", "build", "Lno/nav/security/token/support/client/core/http/OAuth2HttpRequest;", "toString", "token-client-core"})
    @SourceDebugExtension(value={"SMAP\nOAuth2HttpRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OAuth2HttpRequest.kt\nno/nav/security/token/support/client/core/http/OAuth2HttpRequest$OAuth2HttpRequestBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,32:1\n1#2:33\n*E\n"})
    public static final class OAuth2HttpRequestBuilder {
        @NotNull
        private URI tokenEndpointUrl;
        @NotNull
        private OAuth2HttpHeaders oAuth2HttpHeaders;
        @NotNull
        private Map<String, String> formParameters;

        @JvmOverloads
        public OAuth2HttpRequestBuilder(@NotNull URI tokenEndpointUrl, @NotNull OAuth2HttpHeaders oAuth2HttpHeaders, @NotNull Map<String, String> formParameters) {
            Intrinsics.checkNotNullParameter((Object)tokenEndpointUrl, (String)"tokenEndpointUrl");
            Intrinsics.checkNotNullParameter((Object)oAuth2HttpHeaders, (String)"oAuth2HttpHeaders");
            Intrinsics.checkNotNullParameter(formParameters, (String)"formParameters");
            this.tokenEndpointUrl = tokenEndpointUrl;
            this.oAuth2HttpHeaders = oAuth2HttpHeaders;
            this.formParameters = formParameters;
        }

        public /* synthetic */ OAuth2HttpRequestBuilder(URI uRI, OAuth2HttpHeaders oAuth2HttpHeaders, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                oAuth2HttpHeaders = OAuth2HttpHeaders.NONE;
            }
            if ((n & 4) != 0) {
                map = new LinkedHashMap();
            }
            this(uRI, oAuth2HttpHeaders, map);
        }

        @NotNull
        public final OAuth2HttpRequestBuilder tokenEndpointUrl(@NotNull URI tokenEndpointUrl) {
            OAuth2HttpRequestBuilder oAuth2HttpRequestBuilder;
            Intrinsics.checkNotNullParameter((Object)tokenEndpointUrl, (String)"tokenEndpointUrl");
            OAuth2HttpRequestBuilder it = oAuth2HttpRequestBuilder = this;
            boolean bl = false;
            it.tokenEndpointUrl = tokenEndpointUrl;
            return oAuth2HttpRequestBuilder;
        }

        @NotNull
        public final OAuth2HttpRequestBuilder oAuth2HttpHeaders(@NotNull OAuth2HttpHeaders oAuth2HttpHeaders) {
            OAuth2HttpRequestBuilder oAuth2HttpRequestBuilder;
            Intrinsics.checkNotNullParameter((Object)oAuth2HttpHeaders, (String)"oAuth2HttpHeaders");
            OAuth2HttpRequestBuilder it = oAuth2HttpRequestBuilder = this;
            boolean bl = false;
            it.oAuth2HttpHeaders = oAuth2HttpHeaders;
            return oAuth2HttpRequestBuilder;
        }

        @NotNull
        public final OAuth2HttpRequestBuilder formParameter(@NotNull String key, @NotNull String value) {
            OAuth2HttpRequestBuilder oAuth2HttpRequestBuilder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            OAuth2HttpRequestBuilder it = oAuth2HttpRequestBuilder = this;
            boolean bl = false;
            this.formParameters.put(key, value);
            return oAuth2HttpRequestBuilder;
        }

        @NotNull
        public final OAuth2HttpRequestBuilder formParameters(@NotNull Map<String, String> entries) {
            OAuth2HttpRequestBuilder oAuth2HttpRequestBuilder;
            Intrinsics.checkNotNullParameter(entries, (String)"entries");
            OAuth2HttpRequestBuilder it = oAuth2HttpRequestBuilder = this;
            boolean bl = false;
            this.formParameters.putAll(entries);
            return oAuth2HttpRequestBuilder;
        }

        @NotNull
        public final OAuth2HttpRequest build() {
            Map<String, String> map = Collections.unmodifiableMap(this.formParameters);
            Intrinsics.checkNotNullExpressionValue(map, (String)"unmodifiableMap(...)");
            return new OAuth2HttpRequest(this.tokenEndpointUrl, this.oAuth2HttpHeaders, map);
        }

        @NotNull
        public String toString() {
            return "OAuth2HttpRequest.OAuth2HttpRequestBuilder(tokenEndpointUrl=" + this.tokenEndpointUrl + ", oAuth2HttpHeaders=" + this.oAuth2HttpHeaders + ", entries=" + this.formParameters;
        }

        @JvmOverloads
        public OAuth2HttpRequestBuilder(@NotNull URI tokenEndpointUrl, @NotNull OAuth2HttpHeaders oAuth2HttpHeaders) {
            Intrinsics.checkNotNullParameter((Object)tokenEndpointUrl, (String)"tokenEndpointUrl");
            Intrinsics.checkNotNullParameter((Object)oAuth2HttpHeaders, (String)"oAuth2HttpHeaders");
            this(tokenEndpointUrl, oAuth2HttpHeaders, null, 4, null);
        }

        @JvmOverloads
        public OAuth2HttpRequestBuilder(@NotNull URI tokenEndpointUrl) {
            Intrinsics.checkNotNullParameter((Object)tokenEndpointUrl, (String)"tokenEndpointUrl");
            this(tokenEndpointUrl, null, null, 6, null);
        }
    }
}

