/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.core;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.token.support.client.core.oauth2.OAuth2AccessTokenResponse;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J^\u0010\u0003\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u0001H\u0005H\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007 \u0006* \u0012\f\u0012\n \u0006*\u0004\u0018\u0001H\u0005H\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00040\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007J\"\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00070\f\"\u0004\b\u0000\u0010\u00052\u0006\u0010\n\u001a\u00020\tH\u0002\u00a8\u0006\r"}, d2={"Lno/nav/security/token/support/client/core/OAuth2CacheFactory;", "", "()V", "accessTokenResponseCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "T", "kotlin.jvm.PlatformType", "Lno/nav/security/token/support/client/core/oauth2/OAuth2AccessTokenResponse;", "maximumSize", "", "skewInSeconds", "evictOnResponseExpiresIn", "Lcom/github/benmanes/caffeine/cache/Expiry;", "token-client-core"})
public final class OAuth2CacheFactory {
    @NotNull
    public static final OAuth2CacheFactory INSTANCE = new OAuth2CacheFactory();

    private OAuth2CacheFactory() {
    }

    @JvmStatic
    public static final <T> Cache<T, OAuth2AccessTokenResponse> accessTokenResponseCache(long maximumSize, long skewInSeconds) {
        return Caffeine.newBuilder().maximumSize(maximumSize).expireAfter(INSTANCE.evictOnResponseExpiresIn(skewInSeconds)).build();
    }

    private final <T> Expiry<T, OAuth2AccessTokenResponse> evictOnResponseExpiresIn(long skewInSeconds) {
        return new Expiry<T, OAuth2AccessTokenResponse>(skewInSeconds){
            final /* synthetic */ long $skewInSeconds;
            {
                this.$skewInSeconds = $skewInSeconds;
            }

            public long expireAfterCreate(T key, @NotNull OAuth2AccessTokenResponse response, long currentTime) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Integer n = response.getExpiresIn();
                Intrinsics.checkNotNull((Object)n);
                return TimeUnit.SECONDS.toNanos((long)n.intValue() > this.$skewInSeconds ? (long)response.getExpiresIn().intValue() - this.$skewInSeconds : (long)response.getExpiresIn().intValue());
            }

            public long expireAfterUpdate(T key, @NotNull OAuth2AccessTokenResponse response, long currentTime, long currentDuration) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return currentDuration;
            }

            public long expireAfterRead(T key, @NotNull OAuth2AccessTokenResponse response, long currentTime, long currentDuration) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return currentDuration;
            }
        };
    }
}

