/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.core.oauth2;

import com.github.benmanes.caffeine.cache.Cache;
import com.nimbusds.oauth2.sdk.GrantType;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.token.support.client.core.ClientProperties;
import no.nav.security.token.support.client.core.OAuth2ClientException;
import no.nav.security.token.support.client.core.context.JwtBearerTokenResolver;
import no.nav.security.token.support.client.core.oauth2.AbstractOAuth2GrantRequest;
import no.nav.security.token.support.client.core.oauth2.ClientCredentialsGrantRequest;
import no.nav.security.token.support.client.core.oauth2.ClientCredentialsTokenClient;
import no.nav.security.token.support.client.core.oauth2.OAuth2AccessTokenResponse;
import no.nav.security.token.support.client.core.oauth2.OnBehalfOfGrantRequest;
import no.nav.security.token.support.client.core.oauth2.OnBehalfOfTokenClient;
import no.nav.security.token.support.client.core.oauth2.TokenExchangeClient;
import no.nav.security.token.support.client.core.oauth2.TokenExchangeGrantRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0001#Bo\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0016\b\u0002\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b\u0012\u0016\b\u0002\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b\u0012\u0016\b\u0002\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0017\u001a\u00070\r\u00a2\u0006\u0002\b\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0015\u0010\u001b\u001a\u00070\r\u00a2\u0006\u0002\b\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0015\u0010\u001c\u001a\u00070\r\u00a2\u0006\u0002\b\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001aJ\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u001f\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u001f\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lno/nav/security/token/support/client/core/oauth2/OAuth2AccessTokenService;", "", "tokenResolver", "Lno/nav/security/token/support/client/core/context/JwtBearerTokenResolver;", "onBehalfOfTokenClient", "Lno/nav/security/token/support/client/core/oauth2/OnBehalfOfTokenClient;", "clientCredentialsTokenClient", "Lno/nav/security/token/support/client/core/oauth2/ClientCredentialsTokenClient;", "tokenExchangeClient", "Lno/nav/security/token/support/client/core/oauth2/TokenExchangeClient;", "clientCredentialsGrantCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lno/nav/security/token/support/client/core/oauth2/ClientCredentialsGrantRequest;", "Lno/nav/security/token/support/client/core/oauth2/OAuth2AccessTokenResponse;", "exchangeGrantCache", "Lno/nav/security/token/support/client/core/oauth2/TokenExchangeGrantRequest;", "onBehalfOfGrantCache", "Lno/nav/security/token/support/client/core/oauth2/OnBehalfOfGrantRequest;", "(Lno/nav/security/token/support/client/core/context/JwtBearerTokenResolver;Lno/nav/security/token/support/client/core/oauth2/OnBehalfOfTokenClient;Lno/nav/security/token/support/client/core/oauth2/ClientCredentialsTokenClient;Lno/nav/security/token/support/client/core/oauth2/TokenExchangeClient;Lcom/github/benmanes/caffeine/cache/Cache;Lcom/github/benmanes/caffeine/cache/Cache;Lcom/github/benmanes/caffeine/cache/Cache;)V", "getClientCredentialsGrantCache", "()Lcom/github/benmanes/caffeine/cache/Cache;", "getExchangeGrantCache", "getOnBehalfOfGrantCache", "executeClientCredentials", "Lorg/checkerframework/checker/nullness/qual/PolyNull;", "clientProperties", "Lno/nav/security/token/support/client/core/ClientProperties;", "executeOnBehalfOf", "executeTokenExchange", "getAccessToken", "p", "onBehalfOfGrantRequest", "toString", "", "tokenExchangeGrantRequest", "Companion", "token-client-core"})
public final class OAuth2AccessTokenService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JwtBearerTokenResolver tokenResolver;
    @NotNull
    private final OnBehalfOfTokenClient onBehalfOfTokenClient;
    @NotNull
    private final ClientCredentialsTokenClient clientCredentialsTokenClient;
    @NotNull
    private final TokenExchangeClient tokenExchangeClient;
    @Nullable
    private final Cache<ClientCredentialsGrantRequest, OAuth2AccessTokenResponse> clientCredentialsGrantCache;
    @Nullable
    private final Cache<TokenExchangeGrantRequest, OAuth2AccessTokenResponse> exchangeGrantCache;
    @Nullable
    private final Cache<OnBehalfOfGrantRequest, OAuth2AccessTokenResponse> onBehalfOfGrantCache;
    @NotNull
    private static final List<GrantType> SUPPORTED_GRANT_TYPES;
    private static final Logger log;

    @JvmOverloads
    public OAuth2AccessTokenService(@NotNull JwtBearerTokenResolver tokenResolver, @NotNull OnBehalfOfTokenClient onBehalfOfTokenClient, @NotNull ClientCredentialsTokenClient clientCredentialsTokenClient, @NotNull TokenExchangeClient tokenExchangeClient, @Nullable Cache<ClientCredentialsGrantRequest, OAuth2AccessTokenResponse> clientCredentialsGrantCache, @Nullable Cache<TokenExchangeGrantRequest, OAuth2AccessTokenResponse> exchangeGrantCache, @Nullable Cache<OnBehalfOfGrantRequest, OAuth2AccessTokenResponse> onBehalfOfGrantCache) {
        Intrinsics.checkNotNullParameter((Object)tokenResolver, (String)"tokenResolver");
        Intrinsics.checkNotNullParameter((Object)onBehalfOfTokenClient, (String)"onBehalfOfTokenClient");
        Intrinsics.checkNotNullParameter((Object)clientCredentialsTokenClient, (String)"clientCredentialsTokenClient");
        Intrinsics.checkNotNullParameter((Object)tokenExchangeClient, (String)"tokenExchangeClient");
        this.tokenResolver = tokenResolver;
        this.onBehalfOfTokenClient = onBehalfOfTokenClient;
        this.clientCredentialsTokenClient = clientCredentialsTokenClient;
        this.tokenExchangeClient = tokenExchangeClient;
        this.clientCredentialsGrantCache = clientCredentialsGrantCache;
        this.exchangeGrantCache = exchangeGrantCache;
        this.onBehalfOfGrantCache = onBehalfOfGrantCache;
    }

    public /* synthetic */ OAuth2AccessTokenService(JwtBearerTokenResolver jwtBearerTokenResolver, OnBehalfOfTokenClient onBehalfOfTokenClient, ClientCredentialsTokenClient clientCredentialsTokenClient, TokenExchangeClient tokenExchangeClient, Cache cache, Cache cache2, Cache cache3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            cache = null;
        }
        if ((n & 0x20) != 0) {
            cache2 = null;
        }
        if ((n & 0x40) != 0) {
            cache3 = null;
        }
        this(jwtBearerTokenResolver, onBehalfOfTokenClient, clientCredentialsTokenClient, tokenExchangeClient, (Cache<ClientCredentialsGrantRequest, OAuth2AccessTokenResponse>)cache, (Cache<TokenExchangeGrantRequest, OAuth2AccessTokenResponse>)cache2, (Cache<OnBehalfOfGrantRequest, OAuth2AccessTokenResponse>)cache3);
    }

    @Nullable
    public final Cache<ClientCredentialsGrantRequest, OAuth2AccessTokenResponse> getClientCredentialsGrantCache() {
        return this.clientCredentialsGrantCache;
    }

    @Nullable
    public final Cache<TokenExchangeGrantRequest, OAuth2AccessTokenResponse> getExchangeGrantCache() {
        return this.exchangeGrantCache;
    }

    @Nullable
    public final Cache<OnBehalfOfGrantRequest, OAuth2AccessTokenResponse> getOnBehalfOfGrantCache() {
        return this.onBehalfOfGrantCache;
    }

    @NotNull
    public final OAuth2AccessTokenResponse getAccessToken(@NotNull ClientProperties p) {
        OAuth2AccessTokenResponse oAuth2AccessTokenResponse;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Object object = p.getGrantType();
        if (Intrinsics.areEqual((Object)object, (Object)GrantType.JWT_BEARER)) {
            oAuth2AccessTokenResponse = this.executeOnBehalfOf(p);
        } else if (Intrinsics.areEqual((Object)object, (Object)GrantType.CLIENT_CREDENTIALS)) {
            oAuth2AccessTokenResponse = this.executeClientCredentials(p);
        } else if (Intrinsics.areEqual((Object)object, (Object)GrantType.TOKEN_EXCHANGE)) {
            oAuth2AccessTokenResponse = this.executeTokenExchange(p);
        } else {
            throw new OAuth2ClientException("Invalid grant-type " + p.getGrantType().getValue() + " from OAuth2ClientConfig.OAuth2Client. grant-type not in supported grant-types (" + SUPPORTED_GRANT_TYPES + ")", null, 2, null);
        }
        Object it = object = oAuth2AccessTokenResponse;
        boolean bl = false;
        log.debug("Got access_token for grant={}", (Object)p.getGrantType());
        return object;
    }

    private final OAuth2AccessTokenResponse executeOnBehalfOf(ClientProperties clientProperties) {
        return OAuth2AccessTokenService.Companion.getFromCacheIfEnabled(this.onBehalfOfGrantRequest(clientProperties), this.onBehalfOfGrantCache, this.onBehalfOfTokenClient::getTokenResponse);
    }

    private final OAuth2AccessTokenResponse executeTokenExchange(ClientProperties clientProperties) {
        return OAuth2AccessTokenService.Companion.getFromCacheIfEnabled(this.tokenExchangeGrantRequest(clientProperties), this.exchangeGrantCache, this.tokenExchangeClient::getTokenResponse);
    }

    private final OAuth2AccessTokenResponse executeClientCredentials(ClientProperties clientProperties) {
        return OAuth2AccessTokenService.Companion.getFromCacheIfEnabled(new ClientCredentialsGrantRequest(clientProperties), this.clientCredentialsGrantCache, this.clientCredentialsTokenClient::getTokenResponse);
    }

    private final TokenExchangeGrantRequest tokenExchangeGrantRequest(ClientProperties clientProperties) {
        String string = this.tokenResolver.token();
        if (string == null) {
            throw new OAuth2ClientException("no authenticated jwt token found in validation context, cannot do token exchange", null, 2, null);
        }
        return new TokenExchangeGrantRequest(clientProperties, string);
    }

    private final OnBehalfOfGrantRequest onBehalfOfGrantRequest(ClientProperties clientProperties) {
        String string = this.tokenResolver.token();
        if (string == null) {
            throw new OAuth2ClientException("no authenticated jwt token found in validation context, cannot do on-behalf-of", null, 2, null);
        }
        return new OnBehalfOfGrantRequest(clientProperties, string);
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + " [clientCredentialsGrantCache=" + this.clientCredentialsGrantCache + ",  onBehalfOfGrantCache=" + this.onBehalfOfGrantCache + ", tokenExchangeClient=" + this.tokenExchangeClient + ", tokenResolver=" + this.tokenResolver + ", onBehalfOfTokenClient=" + this.onBehalfOfTokenClient + ", clientCredentialsTokenClient=" + this.clientCredentialsTokenClient + ", exchangeGrantCache=" + this.exchangeGrantCache + "]";
    }

    @JvmOverloads
    public OAuth2AccessTokenService(@NotNull JwtBearerTokenResolver tokenResolver, @NotNull OnBehalfOfTokenClient onBehalfOfTokenClient, @NotNull ClientCredentialsTokenClient clientCredentialsTokenClient, @NotNull TokenExchangeClient tokenExchangeClient, @Nullable Cache<ClientCredentialsGrantRequest, OAuth2AccessTokenResponse> clientCredentialsGrantCache, @Nullable Cache<TokenExchangeGrantRequest, OAuth2AccessTokenResponse> exchangeGrantCache) {
        Intrinsics.checkNotNullParameter((Object)tokenResolver, (String)"tokenResolver");
        Intrinsics.checkNotNullParameter((Object)onBehalfOfTokenClient, (String)"onBehalfOfTokenClient");
        Intrinsics.checkNotNullParameter((Object)clientCredentialsTokenClient, (String)"clientCredentialsTokenClient");
        Intrinsics.checkNotNullParameter((Object)tokenExchangeClient, (String)"tokenExchangeClient");
        this(tokenResolver, onBehalfOfTokenClient, clientCredentialsTokenClient, tokenExchangeClient, clientCredentialsGrantCache, exchangeGrantCache, null, 64, null);
    }

    @JvmOverloads
    public OAuth2AccessTokenService(@NotNull JwtBearerTokenResolver tokenResolver, @NotNull OnBehalfOfTokenClient onBehalfOfTokenClient, @NotNull ClientCredentialsTokenClient clientCredentialsTokenClient, @NotNull TokenExchangeClient tokenExchangeClient, @Nullable Cache<ClientCredentialsGrantRequest, OAuth2AccessTokenResponse> clientCredentialsGrantCache) {
        Intrinsics.checkNotNullParameter((Object)tokenResolver, (String)"tokenResolver");
        Intrinsics.checkNotNullParameter((Object)onBehalfOfTokenClient, (String)"onBehalfOfTokenClient");
        Intrinsics.checkNotNullParameter((Object)clientCredentialsTokenClient, (String)"clientCredentialsTokenClient");
        Intrinsics.checkNotNullParameter((Object)tokenExchangeClient, (String)"tokenExchangeClient");
        this(tokenResolver, onBehalfOfTokenClient, clientCredentialsTokenClient, tokenExchangeClient, clientCredentialsGrantCache, null, null, 96, null);
    }

    @JvmOverloads
    public OAuth2AccessTokenService(@NotNull JwtBearerTokenResolver tokenResolver, @NotNull OnBehalfOfTokenClient onBehalfOfTokenClient, @NotNull ClientCredentialsTokenClient clientCredentialsTokenClient, @NotNull TokenExchangeClient tokenExchangeClient) {
        Intrinsics.checkNotNullParameter((Object)tokenResolver, (String)"tokenResolver");
        Intrinsics.checkNotNullParameter((Object)onBehalfOfTokenClient, (String)"onBehalfOfTokenClient");
        Intrinsics.checkNotNullParameter((Object)clientCredentialsTokenClient, (String)"clientCredentialsTokenClient");
        Intrinsics.checkNotNullParameter((Object)tokenExchangeClient, (String)"tokenExchangeClient");
        this(tokenResolver, onBehalfOfTokenClient, clientCredentialsTokenClient, tokenExchangeClient, null, null, null, 112, null);
    }

    static {
        Object[] objectArray = new GrantType[]{GrantType.JWT_BEARER, GrantType.CLIENT_CREDENTIALS, GrantType.TOKEN_EXCHANGE};
        SUPPORTED_GRANT_TYPES = CollectionsKt.listOf((Object[])objectArray);
        log = LoggerFactory.getLogger(OAuth2AccessTokenService.class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JP\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b\"\n\b\u0000\u0010\f*\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u0002H\f2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u00020\n\u0018\u00010\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u00020\n0\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lno/nav/security/token/support/client/core/oauth2/OAuth2AccessTokenService$Companion;", "", "()V", "SUPPORTED_GRANT_TYPES", "", "Lcom/nimbusds/oauth2/sdk/GrantType;", "kotlin.jvm.PlatformType", "log", "Lorg/slf4j/Logger;", "getFromCacheIfEnabled", "Lno/nav/security/token/support/client/core/oauth2/OAuth2AccessTokenResponse;", "Lorg/checkerframework/checker/nullness/qual/PolyNull;", "T", "Lno/nav/security/token/support/client/core/oauth2/AbstractOAuth2GrantRequest;", "grantRequest", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "client", "Ljava/util/function/Function;", "(Lno/nav/security/token/support/client/core/oauth2/AbstractOAuth2GrantRequest;Lcom/github/benmanes/caffeine/cache/Cache;Ljava/util/function/Function;)Lno/nav/security/token/support/client/core/oauth2/OAuth2AccessTokenResponse;", "token-client-core"})
    public static final class Companion {
        private Companion() {
        }

        private final <T extends AbstractOAuth2GrantRequest> OAuth2AccessTokenResponse getFromCacheIfEnabled(T grantRequest, Cache<T, OAuth2AccessTokenResponse> cache, Function<T, OAuth2AccessTokenResponse> client) {
            OAuth2AccessTokenResponse oAuth2AccessTokenResponse;
            OAuth2AccessTokenResponse oAuth2AccessTokenResponse2;
            Cache<T, OAuth2AccessTokenResponse> cache2 = cache;
            if (cache2 != null) {
                Cache<T, OAuth2AccessTokenResponse> it = cache2;
                boolean bl = false;
                log.debug("Cache is enabled so attempt to get from cache or update cache if not present.");
                v1 = (OAuth2AccessTokenResponse)cache.get(grantRequest, client);
            } else {
                v1 = oAuth2AccessTokenResponse2 = null;
            }
            if (oAuth2AccessTokenResponse2 == null) {
                OAuth2AccessTokenResponse oAuth2AccessTokenResponse3 = client.apply(grantRequest);
                Intrinsics.checkNotNullExpressionValue((Object)oAuth2AccessTokenResponse3, (String)"apply(...)");
                oAuth2AccessTokenResponse = oAuth2AccessTokenResponse3;
            } else {
                oAuth2AccessTokenResponse = oAuth2AccessTokenResponse2;
            }
            return oAuth2AccessTokenResponse;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

