/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.core.oauth2;

import com.nimbusds.oauth2.sdk.GrantType;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.token.support.client.core.ClientProperties;
import no.nav.security.token.support.client.core.oauth2.AbstractOAuth2GrantRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lno/nav/security/token/support/client/core/oauth2/TokenExchangeGrantRequest;", "Lno/nav/security/token/support/client/core/oauth2/AbstractOAuth2GrantRequest;", "clientProperties", "Lno/nav/security/token/support/client/core/ClientProperties;", "subjectToken", "", "(Lno/nav/security/token/support/client/core/ClientProperties;Ljava/lang/String;)V", "getSubjectToken", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "token-client-core"})
public final class TokenExchangeGrantRequest
extends AbstractOAuth2GrantRequest {
    @NotNull
    private final String subjectToken;

    public TokenExchangeGrantRequest(@NotNull ClientProperties clientProperties, @NotNull String subjectToken) {
        Intrinsics.checkNotNullParameter((Object)clientProperties, (String)"clientProperties");
        Intrinsics.checkNotNullParameter((Object)subjectToken, (String)"subjectToken");
        GrantType grantType = GrantType.TOKEN_EXCHANGE;
        Intrinsics.checkNotNullExpressionValue((Object)grantType, (String)"TOKEN_EXCHANGE");
        super(grantType, clientProperties);
        this.subjectToken = subjectToken;
    }

    @NotNull
    public final String getSubjectToken() {
        return this.subjectToken;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        TokenExchangeGrantRequest that = (TokenExchangeGrantRequest)other;
        return Intrinsics.areEqual((Object)this.subjectToken, (Object)that.subjectToken);
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{super.hashCode(), this.subjectToken};
        return Objects.hash(objectArray);
    }
}

