/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.ktor;

import com.nimbusds.jwt.SignedJWT;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.token.support.client.core.oauth2.OAuth2AccessTokenResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lno/nav/security/token/support/ktor/DemoTokenResponse;", "", "grantType", "", "tokenResponse", "Lno/nav/security/token/support/client/core/oauth2/OAuth2AccessTokenResponse;", "(Ljava/lang/String;Lno/nav/security/token/support/client/core/oauth2/OAuth2AccessTokenResponse;)V", "claims", "", "getClaims", "()Ljava/util/Map;", "getGrantType", "()Ljava/lang/String;", "getTokenResponse", "()Lno/nav/security/token/support/client/core/oauth2/OAuth2AccessTokenResponse;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "token-client-kotlin-demo"})
public final class DemoTokenResponse {
    @NotNull
    private final String grantType;
    @NotNull
    private final OAuth2AccessTokenResponse tokenResponse;
    @NotNull
    private final Map<String, Object> claims;

    public DemoTokenResponse(@NotNull String grantType, @NotNull OAuth2AccessTokenResponse tokenResponse) {
        Intrinsics.checkNotNullParameter((Object)grantType, (String)"grantType");
        Intrinsics.checkNotNullParameter((Object)tokenResponse, (String)"tokenResponse");
        this.grantType = grantType;
        this.tokenResponse = tokenResponse;
        Map map = SignedJWT.parse((String)this.tokenResponse.getAccessToken()).getJWTClaimsSet().getClaims();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"parse(tokenResponse.acce\u2026oken).jwtClaimsSet.claims");
        this.claims = map;
    }

    @NotNull
    public final String getGrantType() {
        return this.grantType;
    }

    @NotNull
    public final OAuth2AccessTokenResponse getTokenResponse() {
        return this.tokenResponse;
    }

    @NotNull
    public final Map<String, Object> getClaims() {
        return this.claims;
    }

    @NotNull
    public final String component1() {
        return this.grantType;
    }

    @NotNull
    public final OAuth2AccessTokenResponse component2() {
        return this.tokenResponse;
    }

    @NotNull
    public final DemoTokenResponse copy(@NotNull String grantType, @NotNull OAuth2AccessTokenResponse tokenResponse) {
        Intrinsics.checkNotNullParameter((Object)grantType, (String)"grantType");
        Intrinsics.checkNotNullParameter((Object)tokenResponse, (String)"tokenResponse");
        return new DemoTokenResponse(grantType, tokenResponse);
    }

    public static /* synthetic */ DemoTokenResponse copy$default(DemoTokenResponse demoTokenResponse, String string, OAuth2AccessTokenResponse oAuth2AccessTokenResponse, int n, Object object) {
        if ((n & 1) != 0) {
            string = demoTokenResponse.grantType;
        }
        if ((n & 2) != 0) {
            oAuth2AccessTokenResponse = demoTokenResponse.tokenResponse;
        }
        return demoTokenResponse.copy(string, oAuth2AccessTokenResponse);
    }

    @NotNull
    public String toString() {
        return "DemoTokenResponse(grantType=" + this.grantType + ", tokenResponse=" + this.tokenResponse + ")";
    }

    public int hashCode() {
        int result = this.grantType.hashCode();
        result = result * 31 + this.tokenResponse.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DemoTokenResponse)) {
            return false;
        }
        DemoTokenResponse demoTokenResponse = (DemoTokenResponse)other;
        if (!Intrinsics.areEqual((Object)this.grantType, (Object)demoTokenResponse.grantType)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.tokenResponse, (Object)demoTokenResponse.tokenResponse);
    }
}

