/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.demo.spring.rest;

import no.nav.security.token.support.core.api.Protected;
import no.nav.security.token.support.core.api.Unprotected;
import no.nav.security.token.support.demo.spring.client.DemoClient1;
import no.nav.security.token.support.demo.spring.client.DemoClient2;
import no.nav.security.token.support.demo.spring.client.DemoClient3;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@Protected
@RestController
public class DemoController {
    private final DemoClient1 demoClient1;
    private final DemoClient2 demoClient2;
    private final DemoClient3 demoClient3;

    public DemoController(DemoClient1 demoClient1, DemoClient2 demoClient2, DemoClient3 demoClient3) {
        this.demoClient1 = demoClient1;
        this.demoClient2 = demoClient2;
        this.demoClient3 = demoClient3;
    }

    @GetMapping(value={"/protected"})
    public String protectedPath() {
        return "i am protected";
    }

    @Unprotected
    @GetMapping(value={"/unprotected"})
    public String unprotectedPath() {
        return "i am unprotected";
    }

    @Unprotected
    @GetMapping(value={"/unprotected/client_credentials"})
    public String pingWithClientCredentials() {
        return this.demoClient1.ping();
    }

    @GetMapping(value={"/protected/on_behalf_of"})
    public String pingWithOnBehalfOf() {
        return this.demoClient2.ping();
    }

    @GetMapping(value={"/protected/exchange"})
    public String pingExchange() {
        return this.demoClient3.ping();
    }
}

