/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.demo.spring.mockwebserver;

import jakarta.annotation.PreDestroy;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b2\u0006\u0010\n\u001a\u00020\bH\u0012J\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\r\u001a\u00020\bH\u0012J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0012J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0012J\b\u0010\u0014\u001a\u00020\u0015H\u0012J\b\u0010\u0016\u001a\u00020\u0015H\u0017J\u001c\u0010\u0017\u001a\u00020\u00132\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\fH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lno/nav/security/token/support/demo/spring/mockwebserver/MockWebServerConfiguration;", "", "port", "", "(I)V", "server", "Lokhttp3/mockwebserver/MockWebServer;", "decode", "", "kotlin.jvm.PlatformType", "value", "formParameters", "", "formUrlEncodedString", "isTokenRequest", "", "request", "Lokhttp3/mockwebserver/RecordedRequest;", "mockResponse", "Lokhttp3/mockwebserver/MockResponse;", "setup", "", "shutdown", "tokenResponse", "formParams", "Companion", "token-client-spring-demo"})
@SourceDebugExtension(value={"SMAP\nMockWebServerConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockWebServerConfiguration.kt\nno/nav/security/token/support/demo/spring/mockwebserver/MockWebServerConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n766#2:106\n857#2,2:107\n1549#2:109\n1620#2,3:110\n1179#2,2:113\n1253#2,2:115\n1256#2:118\n1#3:117\n*S KotlinDebug\n*F\n+ 1 MockWebServerConfiguration.kt\nno/nav/security/token/support/demo/spring/mockwebserver/MockWebServerConfiguration\n*L\n75#1:106\n75#1:107,2\n76#1:109\n76#1:110,3\n77#1:113,2\n77#1:115,2\n77#1:118\n*E\n"})
public class MockWebServerConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int port;
    @NotNull
    private final MockWebServer server;
    @NotNull
    private static final String TOKEN_RESPONSE_TEMPLATE = "{\n  \"token_type\": \"Bearer\",\n  \"scope\": \"$scope\",\n  \"expires_at\": $expires_at\",\n  \"ext_expires_in\": $ext_expires_in\",\n  \"expires_in\": $expires_in\",\n  \"access_token\": \"$access_token\"\n}\n";
    @NotNull
    private static final String DEFAULT_JSON_RESPONSE = "{\n  \"ping\": \"pong\"\n}\n";
    @NotNull
    private static final String TOKEN_ENDPOINT_URI = "/oauth2/v2.0/token";
    @NotNull
    private static final Logger log;

    public MockWebServerConfiguration(@Value(value="${mockwebserver.port}") int port) {
        this.port = port;
        this.server = new MockWebServer();
        this.setup();
    }

    private void setup() {
        this.server.start(this.port);
        this.server.setDispatcher(new Dispatcher(this){
            final /* synthetic */ MockWebServerConfiguration this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public MockResponse dispatch(@NotNull RecordedRequest request) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                MockWebServerConfiguration.access$getLog$cp().info("received request on url={} with headers={}", (Object)request.getRequestUrl(), (Object)request.getHeaders());
                return MockWebServerConfiguration.access$mockResponse(this.this$0, request);
            }
        });
    }

    private MockResponse mockResponse(RecordedRequest request) {
        MockResponse mockResponse;
        if (this.isTokenRequest(request)) {
            mockResponse = this.tokenResponse(this.formParameters(request.getBody().readUtf8()));
        } else {
            MockResponse mockResponse2;
            MockResponse $this$mockResponse_u24lambda_u240 = mockResponse2 = new MockResponse();
            boolean bl = false;
            $this$mockResponse_u24lambda_u240.setHeader("Content-Type", (Object)"application/json");
            $this$mockResponse_u24lambda_u240.setBody(DEFAULT_JSON_RESPONSE);
            mockResponse = mockResponse2;
        }
        return mockResponse;
    }

    private MockResponse tokenResponse(Map<String, String> formParams) {
        MockResponse mockResponse;
        MockResponse $this$tokenResponse_u24lambda_u241 = mockResponse = new MockResponse();
        boolean bl = false;
        $this$tokenResponse_u24lambda_u241.setResponseCode(200);
        $this$tokenResponse_u24lambda_u241.setHeader("Content-Type", (Object)"application/json");
        String string = formParams.get("scope");
        Intrinsics.checkNotNull((Object)string);
        $this$tokenResponse_u24lambda_u241.setBody(StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)TOKEN_RESPONSE_TEMPLATE, (String)"$scope", (String)string, (boolean)false, (int)4, null), (String)"$expires_at", (String)("" + Instant.now().plusSeconds(3600L).getEpochSecond()), (boolean)false, (int)4, null), (String)"$ext_expires_in", (String)"30", (boolean)false, (int)4, null), (String)"$expires_in", (String)"30", (boolean)false, (int)4, null), (String)"$access_token", (String)"somerandomaccesstoken", (boolean)false, (int)4, null));
        return mockResponse;
    }

    @PreDestroy
    public void shutdown() {
        this.server.shutdown();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isTokenRequest(RecordedRequest request) {
        if (!StringsKt.endsWith$default((String)String.valueOf(request.getRequestUrl()), (String)TOKEN_ENDPOINT_URI, (boolean)false, (int)2, null)) return false;
        String string = request.getHeader("Content-Type");
        if (string == null) return false;
        boolean bl = StringsKt.contains$default((CharSequence)string, (CharSequence)"application/x-www-form-urlencoded", (boolean)false, (int)2, null);
        if (!bl) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, String> formParameters(String formUrlEncodedString) {
        void $this$associateTo$iv$iv;
        String[] stringArray;
        void $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        String[] stringArray2 = new String[]{"&"};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)formUrlEncodedString, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = this.decode(it);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(...)");
            stringArray = new String[]{"="};
            collection.add(StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)2, (int)2, null));
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Object object;
            Map map = destination$iv$iv2;
            List it2 = (List)element$iv$iv;
            boolean bl = false;
            Object e = it2.get(0);
            int n = 1;
            List list = it2;
            if (n <= CollectionsKt.getLastIndex((List)list)) {
                object = list.get(n);
            } else {
                int n2 = n;
                Object e2 = e;
                boolean bl3 = false;
                object = "";
                e = e2;
            }
            stringArray = TuplesKt.to(e, object);
            map.put(stringArray.getFirst(), stringArray.getSecond());
        }
        return destination$iv$iv2;
    }

    private String decode(String value) {
        return URLDecoder.decode(value, StandardCharsets.UTF_8);
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ MockResponse access$mockResponse(MockWebServerConfiguration $this, RecordedRequest request) {
        return $this.mockResponse(request);
    }

    static {
        Logger logger = LoggerFactory.getLogger(MockWebServerConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lno/nav/security/token/support/demo/spring/mockwebserver/MockWebServerConfiguration$Companion;", "", "()V", "DEFAULT_JSON_RESPONSE", "", "TOKEN_ENDPOINT_URI", "TOKEN_RESPONSE_TEMPLATE", "log", "Lorg/slf4j/Logger;", "token-client-spring-demo"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

