/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.oauth2.client;

import java.net.URI;
import java.util.Collections;
import no.nav.security.token.support.oauth2.ClientConfigurationProperties;
import no.nav.security.token.support.oauth2.OAuth2ClientException;
import no.nav.security.token.support.oauth2.client.AbstractOAuth2GrantRequest;
import no.nav.security.token.support.oauth2.client.OAuth2AccessTokenResponse;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

abstract class AbstractOAuth2TokenClient<T extends AbstractOAuth2GrantRequest> {
    private final RestTemplate restTemplate;

    AbstractOAuth2TokenClient(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    OAuth2AccessTokenResponse getTokenResponse(T grantRequest) {
        Assert.notNull(grantRequest, (String)"oAuth2OnBehalfOfGrantRequest cannot be null");
        RequestEntity<?> request = this.convert(grantRequest);
        try {
            return (OAuth2AccessTokenResponse)this.restTemplate.exchange(request, OAuth2AccessTokenResponse.class).getBody();
        }
        catch (HttpStatusCodeException e) {
            throw new OAuth2ClientException(String.format("received %s from tokenendpoint=%s with responsebody=%s", e.getStatusCode(), ((AbstractOAuth2GrantRequest)grantRequest).getClientProperties().getTokenEndpointUrl(), e.getResponseBodyAsString()), e);
        }
    }

    private RequestEntity<?> convert(T grantRequest) {
        HttpHeaders headers = this.tokenRequestHeaders(((AbstractOAuth2GrantRequest)grantRequest).getClientProperties());
        MultiValueMap<String, String> formParameters = this.buildFormParameters(grantRequest);
        URI uri = UriComponentsBuilder.fromUri((URI)((AbstractOAuth2GrantRequest)grantRequest).getClientProperties().getTokenEndpointUrl()).build().toUri();
        return new RequestEntity(formParameters, (MultiValueMap)headers, HttpMethod.POST, uri);
    }

    private HttpHeaders tokenRequestHeaders(ClientConfigurationProperties.ClientProperties clientProperties) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON_UTF8));
        MediaType contentType = MediaType.valueOf((String)"application/x-www-form-urlencoded;charset=UTF-8");
        headers.setContentType(contentType);
        if ("client_secret_basic".equals(clientProperties.getClientAuthMethod())) {
            headers.setBasicAuth(clientProperties.getClientId(), clientProperties.getClientSecret());
        }
        return headers;
    }

    MultiValueMap<String, String> createDefaultFormParameters(T grantRequest) {
        LinkedMultiValueMap formParameters = new LinkedMultiValueMap();
        ClientConfigurationProperties.ClientProperties clientProperties = ((AbstractOAuth2GrantRequest)grantRequest).getClientProperties();
        if ("client_secret_post".equals(clientProperties.getClientAuthMethod())) {
            formParameters.add((Object)"client_id", (Object)clientProperties.getClientId());
            formParameters.add((Object)"client_secret", (Object)clientProperties.getClientSecret());
        }
        formParameters.add((Object)"grant_type", (Object)((AbstractOAuth2GrantRequest)grantRequest).getGrantType().getValue());
        formParameters.add((Object)"scope", (Object)String.join((CharSequence)" ", clientProperties.getScope()));
        return formParameters;
    }

    protected abstract MultiValueMap<String, String> buildFormParameters(T var1);
}

