/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.oauth2.client;

import com.github.benmanes.caffeine.cache.Cache;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import no.nav.security.token.support.core.context.TokenValidationContextHolder;
import no.nav.security.token.support.core.jwt.JwtToken;
import no.nav.security.token.support.oauth2.ClientConfigurationProperties;
import no.nav.security.token.support.oauth2.OAuth2ClientException;
import no.nav.security.token.support.oauth2.OAuth2GrantType;
import no.nav.security.token.support.oauth2.client.AbstractOAuth2GrantRequest;
import no.nav.security.token.support.oauth2.client.ClientCredentialsGrantRequest;
import no.nav.security.token.support.oauth2.client.ClientCredentialsTokenClient;
import no.nav.security.token.support.oauth2.client.OAuth2AccessTokenResponse;
import no.nav.security.token.support.oauth2.client.OnBehalfOfGrantRequest;
import no.nav.security.token.support.oauth2.client.OnBehalfOfTokenClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2AccessTokenService {
    private static final Logger log = LoggerFactory.getLogger(OAuth2AccessTokenService.class);
    public static final List<OAuth2GrantType> SUPPORTED_GRANT_TYPES = Arrays.asList(OAuth2GrantType.JWT_BEARER, OAuth2GrantType.CLIENT_CREDENTIALS);
    private Cache<ClientCredentialsGrantRequest, OAuth2AccessTokenResponse> clientCredentialsGrantCache;
    private Cache<OnBehalfOfGrantRequest, OAuth2AccessTokenResponse> onBehalfOfGrantCache;
    private final TokenValidationContextHolder contextHolder;
    private final OnBehalfOfTokenClient onBehalfOfTokenClient;
    private final ClientCredentialsTokenClient clientCredentialsTokenClient;

    public OAuth2AccessTokenService(TokenValidationContextHolder contextHolder, OnBehalfOfTokenClient onBehalfOfTokenClient, ClientCredentialsTokenClient clientCredentialsTokenClient) {
        this.contextHolder = contextHolder;
        this.onBehalfOfTokenClient = onBehalfOfTokenClient;
        this.clientCredentialsTokenClient = clientCredentialsTokenClient;
    }

    public OAuth2AccessTokenResponse getAccessToken(ClientConfigurationProperties.ClientProperties clientProperties) {
        if (clientProperties == null) {
            throw new OAuth2ClientException("ClientConfigurationProperties.ClientProperties cannot be null");
        }
        log.debug("getting access_token with scopes={} for grant={}", clientProperties.getScope(), (Object)clientProperties.getGrantType());
        if (this.isGrantType(clientProperties, OAuth2GrantType.JWT_BEARER)) {
            return this.getAccessTokenOnBehalfOfAuthenticatedJwtToken(clientProperties);
        }
        if (this.isGrantType(clientProperties, OAuth2GrantType.CLIENT_CREDENTIALS)) {
            return this.getAccessTokenClientCredentials(clientProperties);
        }
        throw new OAuth2ClientException(String.format("invalid grant-type=%s from OAuth2ClientConfig.OAuth2Client. grant-type not in supported grant-types (%s)", clientProperties.getGrantType().getValue(), SUPPORTED_GRANT_TYPES));
    }

    private OAuth2AccessTokenResponse getAccessTokenOnBehalfOfAuthenticatedJwtToken(ClientConfigurationProperties.ClientProperties clientProperties) {
        OnBehalfOfGrantRequest grantRequest = this.onBehalfOfGrantRequest(clientProperties);
        return OAuth2AccessTokenService.getFromCacheIfEnabled(grantRequest, this.onBehalfOfGrantCache, this.onBehalfOfTokenClient::getTokenResponse);
    }

    private OAuth2AccessTokenResponse getAccessTokenClientCredentials(ClientConfigurationProperties.ClientProperties clientProperties) {
        ClientCredentialsGrantRequest grantRequest = new ClientCredentialsGrantRequest(clientProperties);
        return OAuth2AccessTokenService.getFromCacheIfEnabled(grantRequest, this.clientCredentialsGrantCache, this.clientCredentialsTokenClient::getTokenResponse);
    }

    private static <T extends AbstractOAuth2GrantRequest> OAuth2AccessTokenResponse getFromCacheIfEnabled(T grantRequest, Cache<T, OAuth2AccessTokenResponse> cache, Function<T, OAuth2AccessTokenResponse> accessTokenResponseClient) {
        if (cache != null) {
            log.debug("cache is enabled so attempt to get from cache or update cache if not present.");
            return (OAuth2AccessTokenResponse)cache.get(grantRequest, accessTokenResponseClient);
        }
        log.debug("cache is not set, invoke client directly");
        return accessTokenResponseClient.apply(grantRequest);
    }

    private boolean isGrantType(ClientConfigurationProperties.ClientProperties clientProperties, OAuth2GrantType grantType) {
        return Optional.ofNullable(clientProperties).filter(client -> client.getGrantType().equals(grantType)).isPresent();
    }

    private OnBehalfOfGrantRequest onBehalfOfGrantRequest(ClientConfigurationProperties.ClientProperties clientProperties) {
        return new OnBehalfOfGrantRequest(clientProperties, this.authenticatedJwtToken().orElseThrow(() -> new OAuth2ClientException("no authenticated jwt token found in validation context, cannot do on-behalf-of")));
    }

    private Optional<String> authenticatedJwtToken() {
        return this.contextHolder.getTokenValidationContext() != null ? this.contextHolder.getTokenValidationContext().getFirstValidToken().map(JwtToken::getTokenAsString) : Optional.empty();
    }

    public Cache<ClientCredentialsGrantRequest, OAuth2AccessTokenResponse> getClientCredentialsGrantCache() {
        return this.clientCredentialsGrantCache;
    }

    public void setClientCredentialsGrantCache(Cache<ClientCredentialsGrantRequest, OAuth2AccessTokenResponse> clientCredentialsGrantCache) {
        this.clientCredentialsGrantCache = clientCredentialsGrantCache;
    }

    public Cache<OnBehalfOfGrantRequest, OAuth2AccessTokenResponse> getOnBehalfOfGrantCache() {
        return this.onBehalfOfGrantCache;
    }

    public void setOnBehalfOfGrantCache(Cache<OnBehalfOfGrantRequest, OAuth2AccessTokenResponse> onBehalfOfGrantCache) {
        this.onBehalfOfGrantCache = onBehalfOfGrantCache;
    }
}

