/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.oauth2.client;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import no.nav.security.token.support.core.context.TokenValidationContextHolder;
import no.nav.security.token.support.oauth2.EnableOAuth2Client;
import no.nav.security.token.support.oauth2.client.ClientCredentialsTokenClient;
import no.nav.security.token.support.oauth2.client.OAuth2AccessTokenResponse;
import no.nav.security.token.support.oauth2.client.OAuth2AccessTokenService;
import no.nav.security.token.support.oauth2.client.OnBehalfOfTokenClient;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;

@Configuration
public class OAuth2ClientConfiguration
implements ImportAware {
    private AnnotationAttributes enableOAuth2ClientAttributes;

    public void setImportMetadata(AnnotationMetadata enableOAuth2ClientMetadata) {
        this.enableOAuth2ClientAttributes = AnnotationAttributes.fromMap((Map)enableOAuth2ClientMetadata.getAnnotationAttributes(EnableOAuth2Client.class.getName(), false));
        if (this.enableOAuth2ClientAttributes == null) {
            throw new IllegalArgumentException("@EnableOAuth2Client is not present on importing class " + enableOAuth2ClientMetadata.getClassName());
        }
    }

    @Bean
    OAuth2AccessTokenService oAuth2AccessTokenService(RestTemplateBuilder restTemplateBuilder, TokenValidationContextHolder contextHolder) {
        OAuth2AccessTokenService oAuth2AccessTokenService = new OAuth2AccessTokenService(contextHolder, new OnBehalfOfTokenClient(restTemplateBuilder.build()), new ClientCredentialsTokenClient(restTemplateBuilder.build()));
        if (this.enableOAuth2ClientAttributes != null && this.enableOAuth2ClientAttributes.getBoolean("cacheEnabled")) {
            long maximumSize = (Long)this.enableOAuth2ClientAttributes.getNumber("cacheMaximumSize");
            long skewInSeconds = (Long)this.enableOAuth2ClientAttributes.getNumber("cacheEvictSkew");
            oAuth2AccessTokenService.setClientCredentialsGrantCache(this.cache(maximumSize, skewInSeconds));
            oAuth2AccessTokenService.setOnBehalfOfGrantCache(this.cache(maximumSize, skewInSeconds));
        }
        return oAuth2AccessTokenService;
    }

    <T> Cache<T, OAuth2AccessTokenResponse> cache(long maximumSize, long skewInSeconds) {
        return Caffeine.newBuilder().maximumSize(maximumSize).expireAfter(this.evictOnResponseExpiresIn(skewInSeconds)).build();
    }

    private <T> Expiry<T, OAuth2AccessTokenResponse> evictOnResponseExpiresIn(final long skewInSeconds) {
        return new Expiry<T, OAuth2AccessTokenResponse>(){

            public long expireAfterCreate(@NonNull T key, @NonNull OAuth2AccessTokenResponse response, long currentTime) {
                long seconds = (long)response.getExpiresIn() > skewInSeconds ? (long)response.getExpiresIn() - skewInSeconds : (long)response.getExpiresIn();
                return TimeUnit.SECONDS.toNanos(seconds);
            }

            public long expireAfterUpdate(@NonNull T key, @NonNull OAuth2AccessTokenResponse response, long currentTime, long currentDuration) {
                return currentDuration;
            }

            public long expireAfterRead(@NonNull T key, @NonNull OAuth2AccessTokenResponse response, long currentTime, long currentDuration) {
                return currentDuration;
            }
        };
    }
}

