/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.spring.oauth2;

import java.util.Map;
import java.util.Optional;
import no.nav.security.token.support.client.core.OAuth2CacheFactory;
import no.nav.security.token.support.client.core.context.OnBehalfOfAssertionResolver;
import no.nav.security.token.support.client.core.http.OAuth2HttpClient;
import no.nav.security.token.support.client.core.oauth2.ClientCredentialsTokenClient;
import no.nav.security.token.support.client.core.oauth2.OAuth2AccessTokenService;
import no.nav.security.token.support.client.core.oauth2.OnBehalfOfTokenClient;
import no.nav.security.token.support.client.spring.oauth2.DefaultOAuth2HttpClient;
import no.nav.security.token.support.client.spring.oauth2.EnableOAuth2Client;
import no.nav.security.token.support.core.context.TokenValidationContextHolder;
import no.nav.security.token.support.core.jwt.JwtToken;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;

@Configuration
public class OAuth2ClientConfiguration
implements ImportAware {
    private AnnotationAttributes enableOAuth2ClientAttributes;

    public void setImportMetadata(AnnotationMetadata enableOAuth2ClientMetadata) {
        this.enableOAuth2ClientAttributes = AnnotationAttributes.fromMap((Map)enableOAuth2ClientMetadata.getAnnotationAttributes(EnableOAuth2Client.class.getName(), false));
        if (this.enableOAuth2ClientAttributes == null) {
            throw new IllegalArgumentException("@EnableOAuth2Client is not present on importing class " + enableOAuth2ClientMetadata.getClassName());
        }
    }

    @Bean
    OAuth2AccessTokenService oAuth2AccessTokenService(OnBehalfOfAssertionResolver onBehalfOfAssertionResolver, OAuth2HttpClient oAuth2HttpClient) {
        OAuth2AccessTokenService oAuth2AccessTokenService = new OAuth2AccessTokenService(onBehalfOfAssertionResolver, new OnBehalfOfTokenClient(oAuth2HttpClient), new ClientCredentialsTokenClient(oAuth2HttpClient));
        if (this.enableOAuth2ClientAttributes != null && this.enableOAuth2ClientAttributes.getBoolean("cacheEnabled")) {
            long maximumSize = (Long)this.enableOAuth2ClientAttributes.getNumber("cacheMaximumSize");
            long skewInSeconds = (Long)this.enableOAuth2ClientAttributes.getNumber("cacheEvictSkew");
            oAuth2AccessTokenService.setClientCredentialsGrantCache(OAuth2CacheFactory.accessTokenResponseCache((long)maximumSize, (long)skewInSeconds));
            oAuth2AccessTokenService.setOnBehalfOfGrantCache(OAuth2CacheFactory.accessTokenResponseCache((long)maximumSize, (long)skewInSeconds));
        }
        return oAuth2AccessTokenService;
    }

    @Bean
    OAuth2HttpClient oAuth2HttpClient(RestTemplateBuilder restTemplateBuilder) {
        return new DefaultOAuth2HttpClient(restTemplateBuilder);
    }

    @Bean
    OnBehalfOfAssertionResolver onBehalfOfAssertionResolver(TokenValidationContextHolder contextHolder) {
        return () -> contextHolder.getTokenValidationContext() != null ? contextHolder.getTokenValidationContext().getFirstValidToken().map(JwtToken::getTokenAsString) : Optional.empty();
    }
}

