/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.spring.oauth2;

import java.io.IOException;
import no.nav.security.token.support.client.core.oauth2.OAuth2AccessTokenService;
import no.nav.security.token.support.client.spring.ClientConfigurationProperties;
import no.nav.security.token.support.client.spring.oauth2.ClientConfigurationPropertiesMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class OAuth2ClientRequestInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(OAuth2ClientRequestInterceptor.class);
    private final ClientConfigurationProperties properties;
    private final OAuth2AccessTokenService service;
    private final ClientConfigurationPropertiesMatcher matcher;

    public OAuth2ClientRequestInterceptor(ClientConfigurationProperties properties, OAuth2AccessTokenService service, ClientConfigurationPropertiesMatcher matcher) {
        this.properties = properties;
        this.service = service;
        this.matcher = matcher;
    }

    public ClientHttpResponse intercept(HttpRequest req, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        this.matcher.findProperties(this.properties, req).ifPresentOrElse(config -> req.getHeaders().setBearerAuth(this.service.getAccessToken(config).getAccessToken()), () -> LOG.info("Ingen konfig for {}", (Object)req.getURI()));
        return execution.execute(req, body);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [properties=" + this.properties + ", service=" + this.service + ", matcher=" + this.matcher + "]";
    }
}

