/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.spring;

import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import no.nav.security.token.support.client.core.ClientProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConstructorBinding;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(value="no.nav.security.jwt.client")
public class ClientConfigurationProperties {
    @NotEmpty
    @Valid
    private final Map<String, ClientProperties> registration;

    @ConstructorBinding
    public ClientConfigurationProperties(@NotEmpty @Valid Map<String, ClientProperties> registration) {
        this.registration = registration;
    }

    @NotEmpty
    @Valid
    public Map<String, ClientProperties> getRegistration() {
        return this.registration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientConfigurationProperties that = (ClientConfigurationProperties)o;
        return Objects.equals(this.registration, that.registration);
    }

    public int hashCode() {
        return Objects.hash(this.registration);
    }

    public String toString() {
        return "ClientConfigurationProperties(registration=" + this.getRegistration() + ")";
    }
}

