/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.spring.oauth2;

import java.util.Map;
import java.util.Optional;
import no.nav.security.token.support.client.core.OAuth2CacheFactory;
import no.nav.security.token.support.client.core.context.JwtBearerTokenResolver;
import no.nav.security.token.support.client.core.http.OAuth2HttpClient;
import no.nav.security.token.support.client.core.oauth2.ClientCredentialsTokenClient;
import no.nav.security.token.support.client.core.oauth2.OAuth2AccessTokenService;
import no.nav.security.token.support.client.core.oauth2.OnBehalfOfTokenClient;
import no.nav.security.token.support.client.core.oauth2.TokenExchangeClient;
import no.nav.security.token.support.client.spring.ClientConfigurationProperties;
import no.nav.security.token.support.client.spring.oauth2.DefaultOAuth2HttpClient;
import no.nav.security.token.support.client.spring.oauth2.EnableOAuth2Client;
import no.nav.security.token.support.core.context.TokenValidationContextHolder;
import no.nav.security.token.support.core.jwt.JwtToken;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;

@EnableConfigurationProperties(value={ClientConfigurationProperties.class})
@Configuration
public class OAuth2ClientConfiguration
implements ImportAware {
    private AnnotationAttributes enableOAuth2ClientAttributes;

    public void setImportMetadata(AnnotationMetadata enableOAuth2ClientMetadata) {
        this.enableOAuth2ClientAttributes = AnnotationAttributes.fromMap((Map)enableOAuth2ClientMetadata.getAnnotationAttributes(EnableOAuth2Client.class.getName(), false));
        if (this.enableOAuth2ClientAttributes == null) {
            throw new IllegalArgumentException("@EnableOAuth2Client is not present on importing class " + enableOAuth2ClientMetadata.getClassName());
        }
    }

    @Bean
    OAuth2AccessTokenService oAuth2AccessTokenService(JwtBearerTokenResolver jwtBearerTokenResolver, OAuth2HttpClient oAuth2HttpClient) {
        OAuth2AccessTokenService oAuth2AccessTokenService = new OAuth2AccessTokenService(jwtBearerTokenResolver, new OnBehalfOfTokenClient(oAuth2HttpClient), new ClientCredentialsTokenClient(oAuth2HttpClient), new TokenExchangeClient(oAuth2HttpClient));
        if (this.enableOAuth2ClientAttributes != null && this.enableOAuth2ClientAttributes.getBoolean("cacheEnabled")) {
            long maximumSize = (Long)this.enableOAuth2ClientAttributes.getNumber("cacheMaximumSize");
            long skewInSeconds = (Long)this.enableOAuth2ClientAttributes.getNumber("cacheEvictSkew");
            oAuth2AccessTokenService.setClientCredentialsGrantCache(OAuth2CacheFactory.accessTokenResponseCache((long)maximumSize, (long)skewInSeconds));
            oAuth2AccessTokenService.setOnBehalfOfGrantCache(OAuth2CacheFactory.accessTokenResponseCache((long)maximumSize, (long)skewInSeconds));
            oAuth2AccessTokenService.setExchangeGrantCache(OAuth2CacheFactory.accessTokenResponseCache((long)maximumSize, (long)skewInSeconds));
        }
        return oAuth2AccessTokenService;
    }

    @Bean
    OAuth2HttpClient oAuth2HttpClient(RestTemplateBuilder restTemplateBuilder) {
        return new DefaultOAuth2HttpClient(restTemplateBuilder);
    }

    @Bean
    @ConditionalOnClass(value={TokenValidationContextHolder.class})
    JwtBearerTokenResolver jwtBearerTokenResolver(TokenValidationContextHolder contextHolder) {
        return () -> contextHolder.getTokenValidationContext() != null ? contextHolder.getTokenValidationContext().getFirstValidToken().map(JwtToken::getTokenAsString) : Optional.empty();
    }

    @Bean
    @ConditionalOnMissingBean(value={JwtBearerTokenResolver.class})
    @ConditionalOnMissingClass(value={"no.nav.security.token.support.core.context.TokenValidationContextHolder"})
    JwtBearerTokenResolver noopJwtBearerTokenResolver() {
        return () -> {
            throw new UnsupportedOperationException(String.format("a no-op implementation of %s is registered, cannot get token to exchange required for OnBehalfOf/TokenExchange grant", JwtBearerTokenResolver.class));
        };
    }
}

