/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.spring.oauth2;

import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.token.support.client.core.OAuth2CacheFactory;
import no.nav.security.token.support.client.core.context.JwtBearerTokenResolver;
import no.nav.security.token.support.client.core.http.OAuth2HttpClient;
import no.nav.security.token.support.client.core.oauth2.ClientCredentialsTokenClient;
import no.nav.security.token.support.client.core.oauth2.OAuth2AccessTokenService;
import no.nav.security.token.support.client.core.oauth2.OnBehalfOfTokenClient;
import no.nav.security.token.support.client.core.oauth2.TokenExchangeClient;
import no.nav.security.token.support.client.spring.ClientConfigurationProperties;
import no.nav.security.token.support.client.spring.oauth2.DefaultOAuth2HttpClient;
import no.nav.security.token.support.client.spring.oauth2.EnableOAuth2Client;
import no.nav.security.token.support.core.context.TokenValidationContextHolder;
import no.nav.security.token.support.core.jwt.JwtToken;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@EnableConfigurationProperties(value={ClientConfigurationProperties.class})
@Configuration
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\b\u0010\t\u001a\u00020\u0006H\u0017J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0092\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lno/nav/security/token/support/client/spring/oauth2/OAuth2ClientConfiguration;", "Lorg/springframework/context/annotation/ImportAware;", "()V", "attrs", "Lorg/springframework/core/annotation/AnnotationAttributes;", "jwtBearerTokenResolver", "Lno/nav/security/token/support/client/core/context/JwtBearerTokenResolver;", "h", "Lno/nav/security/token/support/core/context/TokenValidationContextHolder;", "noopJwtBearerTokenResolver", "oAuth2AccessTokenService", "Lno/nav/security/token/support/client/core/oauth2/OAuth2AccessTokenService;", "bearerTokenResolver", "client", "Lno/nav/security/token/support/client/core/http/OAuth2HttpClient;", "oAuth2HttpClient", "Lno/nav/security/token/support/client/spring/oauth2/DefaultOAuth2HttpClient;", "b", "Lorg/springframework/boot/web/client/RestTemplateBuilder;", "setImportMetadata", "", "meta", "Lorg/springframework/core/type/AnnotationMetadata;", "token-client-spring"})
public class OAuth2ClientConfiguration
implements ImportAware {
    @Nullable
    private AnnotationAttributes attrs;

    public void setImportMetadata(@NotNull AnnotationMetadata meta) {
        Intrinsics.checkNotNullParameter((Object)meta, (String)"meta");
        AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap((Map)meta.getAnnotationAttributes(EnableOAuth2Client.class.getName(), false));
        if (annotationAttributes == null) {
            OAuth2ClientConfiguration oAuth2ClientConfiguration = this;
            boolean bl = false;
            OAuth2ClientConfiguration oAuth2ClientConfiguration2 = oAuth2ClientConfiguration;
            String string = "@EnableOAuth2Client is not present on importing class " + meta + ".className";
            throw new IllegalArgumentException(string.toString());
        }
        this.attrs = annotationAttributes;
    }

    @Bean
    @NotNull
    public OAuth2AccessTokenService oAuth2AccessTokenService(@NotNull JwtBearerTokenResolver bearerTokenResolver, @NotNull OAuth2HttpClient client) {
        OAuth2AccessTokenService oAuth2AccessTokenService;
        block1: {
            Intrinsics.checkNotNullParameter((Object)bearerTokenResolver, (String)"bearerTokenResolver");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            OAuth2AccessTokenService $this$oAuth2AccessTokenService_u24lambda_u2d2 = oAuth2AccessTokenService = new OAuth2AccessTokenService(bearerTokenResolver, new OnBehalfOfTokenClient(client), new ClientCredentialsTokenClient(client), new TokenExchangeClient(client));
            boolean bl = false;
            AnnotationAttributes annotationAttributes = this.attrs;
            if (annotationAttributes == null) break block1;
            AnnotationAttributes it = annotationAttributes;
            boolean bl2 = false;
            if (it.getBoolean("cacheEnabled")) {
                Number number = it.getNumber("cacheMaximumSize");
                Intrinsics.checkNotNullExpressionValue((Object)number, (String)"it.getNumber<Long>(\"cacheMaximumSize\")");
                long max = number.longValue();
                Number number2 = it.getNumber("cacheEvictSkew");
                Intrinsics.checkNotNullExpressionValue((Object)number2, (String)"it.getNumber<Long>(\"cacheEvictSkew\")");
                long skew = number2.longValue();
                $this$oAuth2AccessTokenService_u24lambda_u2d2.setClientCredentialsGrantCache(OAuth2CacheFactory.accessTokenResponseCache((long)max, (long)skew));
                $this$oAuth2AccessTokenService_u24lambda_u2d2.setOnBehalfOfGrantCache(OAuth2CacheFactory.accessTokenResponseCache((long)max, (long)skew));
                $this$oAuth2AccessTokenService_u24lambda_u2d2.setExchangeGrantCache(OAuth2CacheFactory.accessTokenResponseCache((long)max, (long)skew));
            }
        }
        return oAuth2AccessTokenService;
    }

    @Bean
    @NotNull
    public DefaultOAuth2HttpClient oAuth2HttpClient(@NotNull RestTemplateBuilder b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        RestTemplate restTemplate = b.build();
        Intrinsics.checkNotNullExpressionValue((Object)restTemplate, (String)"b.build()");
        return new DefaultOAuth2HttpClient((RestOperations)restTemplate);
    }

    @Bean
    @ConditionalOnClass(value={TokenValidationContextHolder.class})
    @NotNull
    public JwtBearerTokenResolver jwtBearerTokenResolver(@NotNull TokenValidationContextHolder h) {
        Intrinsics.checkNotNullParameter((Object)h, (String)"h");
        return () -> OAuth2ClientConfiguration.jwtBearerTokenResolver$lambda-4(h);
    }

    @Bean
    @ConditionalOnMissingBean(value={JwtBearerTokenResolver.class})
    @ConditionalOnMissingClass(value={"no.nav.security.token.support.core.context.TokenValidationContextHolder"})
    @NotNull
    public JwtBearerTokenResolver noopJwtBearerTokenResolver() {
        return OAuth2ClientConfiguration::noopJwtBearerTokenResolver$lambda-5;
    }

    private static final String jwtBearerTokenResolver$lambda-4$lambda-3(JwtToken it) {
        return it.getTokenAsString();
    }

    private static final Optional jwtBearerTokenResolver$lambda-4(TokenValidationContextHolder $h) {
        Intrinsics.checkNotNullParameter((Object)$h, (String)"$h");
        Object object = $h.getTokenValidationContext();
        if (object == null || (object = object.getFirstValidToken()) == null || (object = ((Optional)object).map(OAuth2ClientConfiguration::jwtBearerTokenResolver$lambda-4$lambda-3)) == null) {
            object = Optional.empty();
        }
        return object;
    }

    private static final Optional noopJwtBearerTokenResolver$lambda-5() {
        throw new UnsupportedOperationException("a no-op implementation of " + JwtBearerTokenResolver.class + "  is registered, cannot get token to exchange required for OnBehalfOf/TokenExchange grant");
    }
}

