/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.spring.oauth2;

import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.token.support.client.core.ClientProperties;
import no.nav.security.token.support.client.core.oauth2.OAuth2AccessTokenService;
import no.nav.security.token.support.client.spring.ClientConfigurationProperties;
import no.nav.security.token.support.client.spring.oauth2.ClientConfigurationPropertiesMatcher;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lno/nav/security/token/support/client/spring/oauth2/OAuth2ClientRequestInterceptor;", "Lorg/springframework/http/client/ClientHttpRequestInterceptor;", "properties", "Lno/nav/security/token/support/client/spring/ClientConfigurationProperties;", "service", "Lno/nav/security/token/support/client/core/oauth2/OAuth2AccessTokenService;", "matcher", "Lno/nav/security/token/support/client/spring/oauth2/ClientConfigurationPropertiesMatcher;", "(Lno/nav/security/token/support/client/spring/ClientConfigurationProperties;Lno/nav/security/token/support/client/core/oauth2/OAuth2AccessTokenService;Lno/nav/security/token/support/client/spring/oauth2/ClientConfigurationPropertiesMatcher;)V", "intercept", "Lorg/springframework/http/client/ClientHttpResponse;", "req", "Lorg/springframework/http/HttpRequest;", "body", "", "execution", "Lorg/springframework/http/client/ClientHttpRequestExecution;", "toString", "", "token-client-spring"})
public final class OAuth2ClientRequestInterceptor
implements ClientHttpRequestInterceptor {
    @NotNull
    private final ClientConfigurationProperties properties;
    @NotNull
    private final OAuth2AccessTokenService service;
    @NotNull
    private final ClientConfigurationPropertiesMatcher matcher;

    public OAuth2ClientRequestInterceptor(@NotNull ClientConfigurationProperties properties, @NotNull OAuth2AccessTokenService service, @NotNull ClientConfigurationPropertiesMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        this.properties = properties;
        this.service = service;
        this.matcher = matcher;
    }

    @NotNull
    public ClientHttpResponse intercept(@NotNull HttpRequest req, @NotNull byte[] body, @NotNull ClientHttpRequestExecution execution) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
        URI uRI = req.getURI();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"req.uri");
        ClientProperties clientProperties = this.matcher.findProperties(this.properties, uRI).orElse(null);
        if (clientProperties != null) {
            ClientProperties it = clientProperties;
            boolean bl = false;
            req.getHeaders().setBearerAuth(this.service.getAccessToken(it).getAccessToken());
        }
        ClientHttpResponse clientHttpResponse = execution.execute(req, body);
        Intrinsics.checkNotNullExpressionValue((Object)clientHttpResponse, (String)"execution.execute(req, body)");
        return clientHttpResponse;
    }

    @NotNull
    public String toString() {
        return this.getClass() + ".simpleName  [properties=" + this.properties + ", service=" + this.service + ", matcher=" + this.matcher + "]";
    }
}

