/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.spring.oauth2;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import no.nav.security.token.support.client.core.OAuth2ClientException;
import no.nav.security.token.support.client.core.http.OAuth2HttpClient;
import no.nav.security.token.support.client.core.http.OAuth2HttpRequest;
import no.nav.security.token.support.client.core.oauth2.OAuth2AccessTokenResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lno/nav/security/token/support/client/spring/oauth2/DefaultOAuth2HttpClient;", "Lno/nav/security/token/support/client/core/http/OAuth2HttpClient;", "restTemplateBuilder", "Lorg/springframework/boot/web/client/RestTemplateBuilder;", "(Lorg/springframework/boot/web/client/RestTemplateBuilder;)V", "restTemplate", "Lorg/springframework/web/client/RestTemplate;", "convert", "Lorg/springframework/http/RequestEntity;", "req", "Lno/nav/security/token/support/client/core/http/OAuth2HttpRequest;", "headers", "Lorg/springframework/http/HttpHeaders;", "post", "Lno/nav/security/token/support/client/core/oauth2/OAuth2AccessTokenResponse;", "toString", "", "token-client-spring"})
public final class DefaultOAuth2HttpClient
implements OAuth2HttpClient {
    @NotNull
    private final RestTemplate restTemplate;

    public DefaultOAuth2HttpClient(@NotNull RestTemplateBuilder restTemplateBuilder) {
        Intrinsics.checkNotNullParameter((Object)restTemplateBuilder, (String)"restTemplateBuilder");
        RestTemplate restTemplate = restTemplateBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)restTemplate, (String)"restTemplateBuilder.build()");
        this.restTemplate = restTemplate;
    }

    @Nullable
    public OAuth2AccessTokenResponse post(@NotNull OAuth2HttpRequest req) {
        OAuth2AccessTokenResponse oAuth2AccessTokenResponse;
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        try {
            oAuth2AccessTokenResponse = (OAuth2AccessTokenResponse)this.restTemplate.exchange(this.convert(req), OAuth2AccessTokenResponse.class).getBody();
        }
        catch (HttpStatusCodeException e) {
            throw new OAuth2ClientException("Received " + e + ".statusCode from tokenendpoint " + req + ".tokenEndpointUrl with responsebody " + e + ".responseBodyAsString", (Throwable)e);
        }
        return oAuth2AccessTokenResponse;
    }

    private final RequestEntity<?> convert(OAuth2HttpRequest req) {
        LinkedMultiValueMap formParameters = new LinkedMultiValueMap();
        formParameters.setAll(req.getFormParameters());
        return new RequestEntity((Object)formParameters, (MultiValueMap)this.headers(req), HttpMethod.POST, req.getTokenEndpointUrl());
    }

    private final HttpHeaders headers(OAuth2HttpRequest req) {
        HttpHeaders headers = new HttpHeaders();
        headers.putAll(req.getOAuth2HttpHeaders().headers());
        return headers;
    }

    @NotNull
    public String toString() {
        return this.getClass() + ".simpleName  [restTemplate=" + this.restTemplate + "]";
    }
}

