/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.spring.oauth2;

import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import no.nav.security.token.support.client.core.OAuth2ClientException;
import no.nav.security.token.support.client.core.http.OAuth2HttpClient;
import no.nav.security.token.support.client.core.http.OAuth2HttpRequest;
import no.nav.security.token.support.client.core.oauth2.OAuth2AccessTokenResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\"\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\rH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lno/nav/security/token/support/client/spring/oauth2/DefaultOAuth2HttpClient;", "Lno/nav/security/token/support/client/core/http/OAuth2HttpClient;", "builder", "Lorg/springframework/boot/web/client/RestTemplateBuilder;", "(Lorg/springframework/boot/web/client/RestTemplateBuilder;)V", "restOperations", "Lorg/springframework/web/client/RestOperations;", "(Lorg/springframework/web/client/RestOperations;)V", "getRestOperations", "()Lorg/springframework/web/client/RestOperations;", "convert", "Lorg/springframework/http/RequestEntity;", "Lorg/springframework/util/LinkedMultiValueMap;", "", "req", "Lno/nav/security/token/support/client/core/http/OAuth2HttpRequest;", "headers", "Lorg/springframework/http/HttpHeaders;", "post", "Lno/nav/security/token/support/client/core/oauth2/OAuth2AccessTokenResponse;", "toString", "token-client-spring"})
@SourceDebugExtension(value={"SMAP\nDefaultOAuth2HttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultOAuth2HttpClient.kt\nno/nav/security/token/support/client/spring/oauth2/DefaultOAuth2HttpClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,37:1\n1#2:38\n*E\n"})
public class DefaultOAuth2HttpClient
implements OAuth2HttpClient {
    @NotNull
    private final RestOperations restOperations;

    public DefaultOAuth2HttpClient(@NotNull RestOperations restOperations) {
        Intrinsics.checkNotNullParameter((Object)restOperations, (String)"restOperations");
        this.restOperations = restOperations;
    }

    @NotNull
    public final RestOperations getRestOperations() {
        return this.restOperations;
    }

    public DefaultOAuth2HttpClient(@NotNull RestTemplateBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        RestTemplate restTemplate = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)restTemplate, (String)"build(...)");
        this((RestOperations)restTemplate);
    }

    @Nullable
    public OAuth2AccessTokenResponse post(@NotNull OAuth2HttpRequest req) {
        OAuth2AccessTokenResponse oAuth2AccessTokenResponse;
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        try {
            oAuth2AccessTokenResponse = (OAuth2AccessTokenResponse)this.restOperations.exchange(this.convert(req), OAuth2AccessTokenResponse.class).getBody();
        }
        catch (HttpStatusCodeException e) {
            throw new OAuth2ClientException("Received " + e + ".statusCode from tokenendpoint " + req + ".tokenEndpointUrl with responsebody " + e + ".responseBodyAsString", (Throwable)e);
        }
        return oAuth2AccessTokenResponse;
    }

    private final RequestEntity<LinkedMultiValueMap<String, String>> convert(OAuth2HttpRequest req) {
        LinkedMultiValueMap linkedMultiValueMap;
        OAuth2HttpRequest $this$convert_u24lambda_u241 = req;
        boolean bl = false;
        LinkedMultiValueMap $this$convert_u24lambda_u241_u24lambda_u240 = linkedMultiValueMap = new LinkedMultiValueMap();
        boolean bl2 = false;
        $this$convert_u24lambda_u241_u24lambda_u240.setAll($this$convert_u24lambda_u241.getFormParameters());
        URI uRI = $this$convert_u24lambda_u241.getTokenEndpointUrl();
        HttpMethod httpMethod = HttpMethod.POST;
        MultiValueMap multiValueMap = (MultiValueMap)this.headers($this$convert_u24lambda_u241);
        LinkedMultiValueMap linkedMultiValueMap2 = linkedMultiValueMap;
        return new RequestEntity((Object)linkedMultiValueMap2, multiValueMap, httpMethod, uRI);
    }

    private final HttpHeaders headers(OAuth2HttpRequest req) {
        HttpHeaders httpHeaders;
        HttpHeaders $this$headers_u24lambda_u242 = httpHeaders = new HttpHeaders();
        boolean bl = false;
        $this$headers_u24lambda_u242.putAll(req.getOAuth2HttpHeaders().headers());
        return httpHeaders;
    }

    @NotNull
    public String toString() {
        return this.getClass() + ".simpleName  [restTemplate=" + this.restOperations + "]";
    }
}

