/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.client.spring.oauth2;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import no.nav.security.token.support.client.core.OAuth2CacheFactory;
import no.nav.security.token.support.client.core.context.JwtBearerTokenResolver;
import no.nav.security.token.support.client.core.http.OAuth2HttpClient;
import no.nav.security.token.support.client.core.oauth2.ClientCredentialsTokenClient;
import no.nav.security.token.support.client.core.oauth2.OAuth2AccessTokenService;
import no.nav.security.token.support.client.core.oauth2.OnBehalfOfTokenClient;
import no.nav.security.token.support.client.core.oauth2.TokenExchangeClient;
import no.nav.security.token.support.client.spring.ClientConfigurationProperties;
import no.nav.security.token.support.client.spring.oauth2.DefaultOAuth2HttpClient;
import no.nav.security.token.support.client.spring.oauth2.EnableOAuth2Client;
import no.nav.security.token.support.core.context.TokenValidationContextHolder;
import no.nav.security.token.support.core.jwt.JwtToken;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.web.client.RestClient;

@EnableConfigurationProperties(value={ClientConfigurationProperties.class})
@Configuration
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\b\u0010\f\u001a\u00020\tH\u0017J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lno/nav/security/token/support/client/spring/oauth2/OAuth2ClientConfiguration;", "Lorg/springframework/context/annotation/ImportAware;", "()V", "attrs", "Lorg/springframework/core/annotation/AnnotationAttributes;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jwtBearerTokenResolver", "Lno/nav/security/token/support/client/core/context/JwtBearerTokenResolver;", "h", "Lno/nav/security/token/support/core/context/TokenValidationContextHolder;", "noopJwtBearerTokenResolver", "oAuth2AccessTokenService", "Lno/nav/security/token/support/client/core/oauth2/OAuth2AccessTokenService;", "bearerTokenResolver", "client", "Lno/nav/security/token/support/client/core/http/OAuth2HttpClient;", "oAuth2HttpClient", "Lno/nav/security/token/support/client/spring/oauth2/DefaultOAuth2HttpClient;", "builder", "Lorg/springframework/web/client/RestClient$Builder;", "setImportMetadata", "", "meta", "Lorg/springframework/core/type/AnnotationMetadata;", "token-client-spring"})
@SourceDebugExtension(value={"SMAP\nOAuth2ClientConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OAuth2ClientConfiguration.kt\nno/nav/security/token/support/client/spring/oauth2/OAuth2ClientConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1#2:72\n*E\n"})
public class OAuth2ClientConfiguration
implements ImportAware {
    private final Logger log = LoggerFactory.getLogger(OAuth2ClientConfiguration.class);
    @Nullable
    private AnnotationAttributes attrs;

    public void setImportMetadata(@NotNull AnnotationMetadata meta) {
        Intrinsics.checkNotNullParameter((Object)meta, (String)"meta");
        AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap((Map)meta.getAnnotationAttributes(EnableOAuth2Client.class.getName(), false));
        if (annotationAttributes == null) {
            OAuth2ClientConfiguration oAuth2ClientConfiguration = this;
            boolean bl = false;
            OAuth2ClientConfiguration oAuth2ClientConfiguration2 = oAuth2ClientConfiguration;
            String string = "@EnableOAuth2Client is not present on importing class " + meta.getClassName();
            throw new IllegalArgumentException(string.toString());
        }
        this.attrs = annotationAttributes;
    }

    @Bean
    @NotNull
    public OAuth2AccessTokenService oAuth2AccessTokenService(@NotNull JwtBearerTokenResolver bearerTokenResolver, @NotNull OAuth2HttpClient client) {
        OAuth2AccessTokenService oAuth2AccessTokenService;
        Intrinsics.checkNotNullParameter((Object)bearerTokenResolver, (String)"bearerTokenResolver");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        AnnotationAttributes annotationAttributes = this.attrs;
        boolean bl = annotationAttributes != null ? annotationAttributes.getBoolean("cacheEnabled") : false;
        if (bl) {
            this.log.trace("Caching is enabled");
            Object object = this.attrs;
            if (object == null || (object = (Long)object.getNumber("cacheMaximumSize")) == null) {
                object = 0L;
            }
            long maxx = ((Number)object).longValue();
            Object object2 = this.attrs;
            if (object2 == null || (object2 = (Long)object2.getNumber("cacheEvictSkew")) == null) {
                object2 = 0L;
            }
            long skew = ((Number)object2).longValue();
            oAuth2AccessTokenService = new OAuth2AccessTokenService(bearerTokenResolver, new OnBehalfOfTokenClient(client), new ClientCredentialsTokenClient(client), new TokenExchangeClient(client), OAuth2CacheFactory.accessTokenResponseCache((long)maxx, (long)skew), OAuth2CacheFactory.accessTokenResponseCache((long)maxx, (long)skew), OAuth2CacheFactory.accessTokenResponseCache((long)maxx, (long)skew));
        } else {
            oAuth2AccessTokenService = new OAuth2AccessTokenService(bearerTokenResolver, new OnBehalfOfTokenClient(client), new ClientCredentialsTokenClient(client), new TokenExchangeClient(client), null, null, null, 112, null);
        }
        return oAuth2AccessTokenService;
    }

    @Bean
    @ConditionalOnMissingBean(value={OAuth2HttpClient.class})
    @NotNull
    public DefaultOAuth2HttpClient oAuth2HttpClient(@NotNull RestClient.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        RestClient restClient = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)restClient, (String)"build(...)");
        return new DefaultOAuth2HttpClient(restClient);
    }

    @Bean
    @ConditionalOnClass(value={TokenValidationContextHolder.class})
    @NotNull
    public JwtBearerTokenResolver jwtBearerTokenResolver(@NotNull TokenValidationContextHolder h) {
        Intrinsics.checkNotNullParameter((Object)h, (String)"h");
        return () -> OAuth2ClientConfiguration.jwtBearerTokenResolver$lambda$1(h);
    }

    @Bean
    @ConditionalOnMissingBean(value={JwtBearerTokenResolver.class})
    @ConditionalOnMissingClass(value={"no.nav.security.token.support.core.context.TokenValidationContextHolder"})
    @NotNull
    public JwtBearerTokenResolver noopJwtBearerTokenResolver() {
        return OAuth2ClientConfiguration::noopJwtBearerTokenResolver$lambda$2;
    }

    private static final String jwtBearerTokenResolver$lambda$1(TokenValidationContextHolder $h) {
        Intrinsics.checkNotNullParameter((Object)$h, (String)"$h");
        JwtToken jwtToken = $h.getTokenValidationContext().getFirstValidToken();
        return jwtToken != null ? jwtToken.getEncodedToken() : null;
    }

    private static final String noopJwtBearerTokenResolver$lambda$2() {
        throw new UnsupportedOperationException("A no-op implementation of " + JwtBearerTokenResolver.class + "  is registered, cannot get token to exchange required for OnBehalfOf/TokenExchange grant");
    }
}

