/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.configuration;

import com.nimbusds.jose.util.ResourceRetriever;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import no.nav.security.token.support.core.configuration.IssuerConfiguration;
import no.nav.security.token.support.core.configuration.IssuerProperties;
import no.nav.security.token.support.core.configuration.ProxyAwareResourceRetriever;

public class MultiIssuerConfiguration {
    private final List<String> issuerShortNames = new ArrayList<String>();
    private ResourceRetriever resourceRetriever;
    private final Map<String, IssuerConfiguration> issuers = new HashMap<String, IssuerConfiguration>();
    private final Map<String, IssuerProperties> issuerPropertiesMap;

    public MultiIssuerConfiguration(Map<String, IssuerProperties> issuerPropertiesMap) {
        this(issuerPropertiesMap, null);
    }

    public MultiIssuerConfiguration(Map<String, IssuerProperties> issuerPropertiesMap, ResourceRetriever resourceRetriever) {
        this.issuerPropertiesMap = issuerPropertiesMap;
        this.resourceRetriever = resourceRetriever;
        this.loadIssuerConfigurations();
    }

    public Map<String, IssuerConfiguration> getIssuers() {
        return this.issuers;
    }

    public Optional<IssuerConfiguration> getIssuer(String name) {
        return Optional.ofNullable(this.issuers.get(name));
    }

    public List<String> getIssuerShortNames() {
        return this.issuerShortNames;
    }

    public ResourceRetriever getResourceRetriever() {
        if (this.resourceRetriever == null) {
            this.resourceRetriever = this.createDefaultResourceRetriever();
        }
        return this.resourceRetriever;
    }

    private void loadIssuerConfigurations() {
        for (Map.Entry<String, IssuerProperties> entry : this.issuerPropertiesMap.entrySet()) {
            String shortName = entry.getKey();
            this.issuerShortNames.add(shortName);
            IssuerConfiguration config = this.createIssuerConfiguration(shortName, entry.getValue());
            this.issuers.put(shortName, config);
            this.issuers.put(config.getMetaData().getIssuer().toString(), config);
        }
    }

    private IssuerConfiguration createIssuerConfiguration(String shortName, IssuerProperties issuerProperties) {
        if (issuerProperties.isUsePlaintextForHttps() || issuerProperties.getProxyUrl() != null) {
            ProxyAwareResourceRetriever resourceRetrieverWithProxy = new ProxyAwareResourceRetriever(issuerProperties.getProxyUrl(), issuerProperties.isUsePlaintextForHttps());
            return new IssuerConfiguration(shortName, issuerProperties, (ResourceRetriever)resourceRetrieverWithProxy);
        }
        return new IssuerConfiguration(shortName, issuerProperties, this.getResourceRetriever());
    }

    protected ResourceRetriever createDefaultResourceRetriever() {
        return new ProxyAwareResourceRetriever();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [issuerShortNames=" + this.issuerShortNames + ", resourceRetriever=" + this.resourceRetriever + ", issuers=" + this.issuers + ", issuerPropertiesMap=" + this.issuerPropertiesMap + "]";
    }
}

