/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.configuration;

import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import no.nav.security.token.support.core.configuration.IssuerProperties;
import no.nav.security.token.support.core.configuration.ProxyAwareResourceRetriever;
import no.nav.security.token.support.core.exceptions.MetaDataNotAvailableException;
import no.nav.security.token.support.core.validation.JwtTokenValidator;

public class IssuerConfiguration {
    private String name;
    private OIDCProviderMetadata metaData;
    private final List<String> acceptedAudience;
    private String cookieName;
    private JwtTokenValidator tokenValidator;
    private ResourceRetriever resourceRetriever;

    public IssuerConfiguration(String shortName, IssuerProperties issuerProperties, ResourceRetriever resourceRetriever) {
        this(shortName, issuerProperties.getDiscoveryUrl(), issuerProperties.getAcceptedAudience(), resourceRetriever);
        this.cookieName = issuerProperties.getCookieName();
    }

    public IssuerConfiguration(String name, URL discoveryUrl, List<String> acceptedAudience, ResourceRetriever resourceRetriever) {
        this(name, IssuerConfiguration.getProviderMetadata(resourceRetriever, discoveryUrl), acceptedAudience, resourceRetriever);
    }

    public IssuerConfiguration(String name, OIDCProviderMetadata metaData, List<String> acceptedAudience, ResourceRetriever resourceRetriever) {
        this.name = name;
        this.metaData = metaData;
        this.acceptedAudience = acceptedAudience;
        this.resourceRetriever = resourceRetriever;
        this.tokenValidator = new JwtTokenValidator(metaData.getIssuer().toString(), acceptedAudience, IssuerConfiguration.getJwksUrl(metaData), resourceRetriever);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getAcceptedAudience() {
        return this.acceptedAudience;
    }

    public void setTokenValidator(JwtTokenValidator tokenValidator) {
        this.tokenValidator = tokenValidator;
    }

    public JwtTokenValidator getTokenValidator() {
        return this.tokenValidator;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public OIDCProviderMetadata getMetaData() {
        return this.metaData;
    }

    public void setMetaData(OIDCProviderMetadata metaData) {
        this.metaData = metaData;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ResourceRetriever getResourceRetriever() {
        if (this.resourceRetriever == null) {
            this.resourceRetriever = new ProxyAwareResourceRetriever();
        }
        return this.resourceRetriever;
    }

    public void setResourceRetriever(ResourceRetriever resourceRetriever) {
        this.resourceRetriever = resourceRetriever;
    }

    protected static URL getJwksUrl(OIDCProviderMetadata metaData) {
        try {
            return metaData.getJWKSetURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new MetaDataNotAvailableException(e);
        }
    }

    protected static OIDCProviderMetadata getProviderMetadata(ResourceRetriever resourceRetriever, URL url) {
        if (url == null) {
            throw new MetaDataNotAvailableException("discoveryUrl cannot be null, check your configuration.");
        }
        try {
            return OIDCProviderMetadata.parse((String)resourceRetriever.retrieveResource(url).getContent());
        }
        catch (ParseException | IOException e) {
            throw new MetaDataNotAvailableException(url, (Exception)e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [name=" + this.name + ", metaData=" + this.metaData + ", acceptedAudience=" + this.acceptedAudience + ", cookieName=" + this.cookieName + ", tokenValidator=" + this.tokenValidator + ", resourceRetriever=" + this.resourceRetriever + "]";
    }
}

