/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.configuration;

import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import no.nav.security.token.support.core.configuration.IssuerProperties;
import no.nav.security.token.support.core.configuration.ProxyAwareResourceRetriever;
import no.nav.security.token.support.core.exceptions.MetaDataNotAvailableException;
import no.nav.security.token.support.core.validation.ConfigurableJwtTokenValidator;
import no.nav.security.token.support.core.validation.DefaultJwtTokenValidator;
import no.nav.security.token.support.core.validation.JwtTokenValidator;

public class IssuerConfiguration {
    private String name;
    private AuthorizationServerMetadata metaData;
    private final List<String> acceptedAudience;
    private String cookieName;
    private final JwtTokenValidator tokenValidator;
    private ResourceRetriever resourceRetriever;

    public IssuerConfiguration(String name, IssuerProperties issuerProperties, ResourceRetriever resourceRetriever) {
        this.name = name;
        this.resourceRetriever = resourceRetriever;
        this.metaData = IssuerConfiguration.getProviderMetadata(resourceRetriever, issuerProperties.getDiscoveryUrl());
        this.acceptedAudience = issuerProperties.getAcceptedAudience();
        this.cookieName = issuerProperties.getCookieName();
        this.tokenValidator = this.createTokenValidator(issuerProperties);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getAcceptedAudience() {
        return this.acceptedAudience;
    }

    public JwtTokenValidator getTokenValidator() {
        return this.tokenValidator;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public AuthorizationServerMetadata getMetaData() {
        return this.metaData;
    }

    public void setMetaData(AuthorizationServerMetadata metaData) {
        this.metaData = metaData;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ResourceRetriever getResourceRetriever() {
        if (this.resourceRetriever == null) {
            this.resourceRetriever = new ProxyAwareResourceRetriever();
        }
        return this.resourceRetriever;
    }

    public void setResourceRetriever(ResourceRetriever resourceRetriever) {
        this.resourceRetriever = resourceRetriever;
    }

    protected static URL getJwksUrl(AuthorizationServerMetadata metaData) {
        try {
            return metaData.getJWKSetURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new MetaDataNotAvailableException(e);
        }
    }

    protected static AuthorizationServerMetadata getProviderMetadata(ResourceRetriever resourceRetriever, URL url) {
        if (url == null) {
            throw new MetaDataNotAvailableException("discoveryUrl cannot be null, check your configuration.");
        }
        try {
            return AuthorizationServerMetadata.parse((String)resourceRetriever.retrieveResource(url).getContent());
        }
        catch (ParseException | IOException e) {
            throw new MetaDataNotAvailableException(url, (Exception)e);
        }
    }

    private JwtTokenValidator createTokenValidator(IssuerProperties issuerProperties) {
        return issuerProperties.getValidation().getOptionalClaims().isEmpty() ? new DefaultJwtTokenValidator(this.metaData.getIssuer().getValue(), this.acceptedAudience, IssuerConfiguration.getJwksUrl(this.metaData), this.resourceRetriever) : new ConfigurableJwtTokenValidator(this.metaData.getIssuer().getValue(), IssuerConfiguration.getJwksUrl(this.metaData), this.resourceRetriever, issuerProperties.getValidation().getOptionalClaims());
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [name=" + this.name + ", metaData=" + this.metaData + ", acceptedAudience=" + this.acceptedAudience + ", cookieName=" + this.cookieName + ", tokenValidator=" + this.tokenValidator + ", resourceRetriever=" + this.resourceRetriever + "]";
    }
}

