/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.configuration;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.validation.constraints.NotNull;

public class IssuerProperties {
    @NotNull
    private URL discoveryUrl;
    private List<String> acceptedAudience;
    private String cookieName;
    private URL proxyUrl;
    private boolean usePlaintextForHttps = false;
    private Validation validation = new Validation(Collections.emptyList());

    public IssuerProperties(URL discoveryUrl) {
        this.discoveryUrl = discoveryUrl;
    }

    public IssuerProperties(URL discoveryUrl, List<String> acceptedAudience) {
        this.discoveryUrl = discoveryUrl;
        this.acceptedAudience = acceptedAudience;
    }

    public IssuerProperties(URL discoveryUrl, List<String> acceptedAudience, String cookieName) {
        this(discoveryUrl, acceptedAudience);
        this.cookieName = cookieName;
    }

    public IssuerProperties(URL discoveryUrl, Validation validation) {
        this(discoveryUrl);
        this.validation = validation;
    }

    public URL getDiscoveryUrl() {
        return this.discoveryUrl;
    }

    public List<String> getAcceptedAudience() {
        return this.acceptedAudience;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public URL getProxyUrl() {
        return this.proxyUrl;
    }

    public boolean isUsePlaintextForHttps() {
        return this.usePlaintextForHttps;
    }

    public Validation getValidation() {
        return this.validation;
    }

    public void setDiscoveryUrl(URL discoveryUrl) {
        this.discoveryUrl = discoveryUrl;
    }

    public void setAcceptedAudience(List<String> acceptedAudience) {
        this.acceptedAudience = acceptedAudience;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public void setProxyUrl(URL proxyUrl) {
        this.proxyUrl = proxyUrl;
    }

    public void setUsePlaintextForHttps(boolean usePlaintextForHttps) {
        this.usePlaintextForHttps = usePlaintextForHttps;
    }

    public void setValidation(Validation validation) {
        this.validation = validation;
    }

    public String toString() {
        return "IssuerProperties(discoveryUrl=" + this.getDiscoveryUrl() + ", acceptedAudience=" + this.getAcceptedAudience() + ", cookieName=" + this.getCookieName() + ", proxyUrl=" + this.getProxyUrl() + ", usePlaintextForHttps=" + this.isUsePlaintextForHttps() + ", validation=" + this.getValidation() + ")";
    }

    public IssuerProperties() {
    }

    public static class Validation {
        private List<String> optionalClaims;

        public Validation(List<String> optionalClaims) {
            this.optionalClaims = Optional.ofNullable(optionalClaims).orElse(Collections.emptyList());
        }

        public List<String> getOptionalClaims() {
            return this.optionalClaims;
        }

        public void setOptionalClaims(List<String> optionalClaims) {
            this.optionalClaims = optionalClaims;
        }

        public String toString() {
            return "IssuerProperties.Validation(optionalClaims=" + this.getOptionalClaims() + ")";
        }
    }
}

