/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import no.nav.security.token.support.core.api.Protected;
import no.nav.security.token.support.core.api.ProtectedWithClaims;
import no.nav.security.token.support.core.api.Unprotected;
import no.nav.security.token.support.core.context.TokenValidationContextHolder;
import no.nav.security.token.support.core.exceptions.AnnotationRequiredException;
import no.nav.security.token.support.core.exceptions.JwtTokenInvalidClaimException;
import no.nav.security.token.support.core.exceptions.JwtTokenMissingException;
import no.nav.security.token.support.core.jwt.JwtToken;
import no.nav.security.token.support.core.utils.JwtTokenUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtTokenAnnotationHandler {
    private static final Logger log = LoggerFactory.getLogger(JwtTokenAnnotationHandler.class);
    private final TokenValidationContextHolder tokenValidationContextHolder;

    public JwtTokenAnnotationHandler(TokenValidationContextHolder tokenValidationContextHolder) {
        this.tokenValidationContextHolder = tokenValidationContextHolder;
    }

    public boolean assertValidAnnotation(Method method) throws AnnotationRequiredException {
        Annotation annotation = this.getAnnotation(method, Arrays.asList(ProtectedWithClaims.class, Protected.class, Unprotected.class));
        if (annotation == null) {
            throw new AnnotationRequiredException("Server misconfigured - controller/method [" + method.getClass().getName() + "." + method.getName() + "] not annotated @Unprotected, @Protected or added to ignore list");
        }
        return this.assertValidAnnotation(annotation);
    }

    private boolean assertValidAnnotation(Annotation annotation) {
        if (annotation instanceof Unprotected) {
            log.debug("annotation is of type={}, no token validation performed.", (Object)Unprotected.class.getSimpleName());
            return true;
        }
        if (annotation instanceof ProtectedWithClaims) {
            log.debug("annotation is of type={}, do token validation and claim checking.", (Object)ProtectedWithClaims.class.getSimpleName());
            return this.handleProtectedWithClaimsAnnotation((ProtectedWithClaims)annotation);
        }
        if (annotation instanceof Protected) {
            log.debug("annotation is of type={}, check if context has valid token.", (Object)Protected.class.getSimpleName());
            if (JwtTokenUtil.contextHasValidToken(this.tokenValidationContextHolder)) {
                return true;
            }
            throw new JwtTokenMissingException("no valid token found in validation context");
        }
        log.debug("annotation is unknown,  type={}, no token validation performed. but possible bug so throw exception", annotation.annotationType());
        return false;
    }

    protected Annotation getAnnotation(Method method, List<Class<? extends Annotation>> types) {
        Annotation annotation = JwtTokenAnnotationHandler.findAnnotation(method.getAnnotations(), types);
        if (annotation != null) {
            log.debug("method " + method + " marked @{}", annotation.annotationType());
            return annotation;
        }
        Class<?> declaringClass = method.getDeclaringClass();
        annotation = JwtTokenAnnotationHandler.findAnnotation(declaringClass.getAnnotations(), types);
        if (annotation != null) {
            log.debug("method {} marked @{} through annotation on class", (Object)method, annotation.annotationType());
            return annotation;
        }
        return null;
    }

    private static Annotation findAnnotation(Annotation[] annotations, List<Class<? extends Annotation>> types) {
        return annotations != null ? (Annotation)Arrays.stream(annotations).filter(a -> types.contains(a.annotationType())).findFirst().orElse(null) : null;
    }

    protected boolean handleProtectedWithClaimsAnnotation(ProtectedWithClaims annotation) {
        return this.handleProtectedWithClaims(annotation.issuer(), annotation.claimMap(), annotation.combineWithOr());
    }

    protected boolean handleProtectedWithClaims(String issuer, String[] requiredClaims, boolean combineWithOr) {
        JwtToken jwtToken;
        if (Objects.nonNull(issuer) && issuer.length() > 0 && !this.containsRequiredClaims(jwtToken = JwtTokenUtil.getJwtToken(issuer, this.tokenValidationContextHolder).orElseThrow(() -> new JwtTokenMissingException("no valid token found in validation context")), combineWithOr, requiredClaims)) {
            throw new JwtTokenInvalidClaimException("required claims not present in token." + Arrays.asList(requiredClaims));
        }
        return true;
    }

    protected boolean containsRequiredClaims(JwtToken jwtBearerToken, boolean combineWithOr, String ... claims) {
        log.debug("choose matching logic based on combineWithOr=" + combineWithOr);
        return combineWithOr ? this.containsAnyClaim(jwtBearerToken, claims) : this.containsAllClaims(jwtBearerToken, claims);
    }

    private boolean containsAllClaims(JwtToken jwtToken, String ... claims) {
        if (claims != null && claims.length > 0) {
            return Arrays.stream(claims).map(claimUnparsed -> claimUnparsed.split("=")).filter(pair -> ((String[])pair).length == 2).allMatch(pair -> jwtToken.containsClaim(pair[0].trim(), pair[1].trim()));
        }
        return true;
    }

    private boolean containsAnyClaim(JwtToken jwtToken, String ... claims) {
        if (claims != null && claims.length > 0) {
            return Arrays.stream(claims).map(claimUnparsed -> claimUnparsed.split("=")).filter(pair -> ((String[])pair).length == 2).anyMatch(pair -> jwtToken.containsClaim(pair[0].trim(), pair[1].trim()));
        }
        log.debug("no claims listed, so claim checking is ok.");
        return true;
    }
}

