/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.validation;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import no.nav.security.token.support.core.configuration.IssuerConfiguration;
import no.nav.security.token.support.core.configuration.MultiIssuerConfiguration;
import no.nav.security.token.support.core.context.TokenValidationContext;
import no.nav.security.token.support.core.exceptions.IssuerConfigurationException;
import no.nav.security.token.support.core.exceptions.JwtTokenValidatorException;
import no.nav.security.token.support.core.http.HttpRequest;
import no.nav.security.token.support.core.jwt.JwtToken;
import no.nav.security.token.support.core.validation.JwtTokenRetriever;
import no.nav.security.token.support.core.validation.JwtTokenValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtTokenValidationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(JwtTokenValidationHandler.class);
    private final MultiIssuerConfiguration config;

    public JwtTokenValidationHandler(MultiIssuerConfiguration config) {
        this.config = config;
    }

    public TokenValidationContext getValidatedTokens(HttpRequest request) {
        List<JwtToken> tokensOnRequest = JwtTokenRetriever.retrieveUnvalidatedTokens(this.config, request);
        Map validatedTokens = tokensOnRequest.stream().map(this::validate).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toConcurrentMap(Map.Entry::getKey, Map.Entry::getValue));
        LOG.debug("found {} tokens on request, number of validated tokens is {}", (Object)tokensOnRequest.size(), (Object)validatedTokens.size());
        return new TokenValidationContext(validatedTokens);
    }

    private Optional<Map.Entry<String, JwtToken>> validate(JwtToken jwtToken) {
        try {
            LOG.debug("check if token with issuer={} is present in config", (Object)jwtToken.getIssuer());
            if (this.config.getIssuer(jwtToken.getIssuer()).isPresent()) {
                String issuerShortName = this.issuerConfiguration(jwtToken.getIssuer()).getName();
                LOG.debug("found token from trusted issuer={} with shortName={} in request", (Object)jwtToken.getIssuer(), (Object)issuerShortName);
                long start = System.currentTimeMillis();
                this.tokenValidator(jwtToken).assertValidToken(jwtToken.getTokenAsString());
                long end = System.currentTimeMillis();
                LOG.debug("validated token from issuer[{}] in {} ms", (Object)jwtToken.getIssuer(), (Object)(end - start));
                return Optional.of(JwtTokenValidationHandler.entry(issuerShortName, jwtToken));
            }
            LOG.debug("token is from an unknown issuer={}, skipping validation.", (Object)jwtToken.getIssuer());
            return Optional.empty();
        }
        catch (JwtTokenValidatorException e) {
            LOG.info("found invalid token for issuer [{}, expires at {}], exception message:{} ", new Object[]{jwtToken.getIssuer(), e.getExpiryDate(), e.getMessage()});
            return Optional.empty();
        }
    }

    private JwtTokenValidator tokenValidator(JwtToken jwtToken) {
        return this.issuerConfiguration(jwtToken.getIssuer()).getTokenValidator();
    }

    private IssuerConfiguration issuerConfiguration(String issuer) {
        return this.config.getIssuer(issuer).orElseThrow(JwtTokenValidationHandler.issuerConfigurationException(String.format("could not find IssuerConfiguration for issuer=%s", issuer)));
    }

    private static Supplier<IssuerConfigurationException> issuerConfigurationException(String message) {
        return () -> new IssuerConfigurationException(message);
    }

    private static <T, U> Map.Entry<T, U> entry(T key, U value) {
        return new AbstractMap.SimpleImmutableEntry<T, U>(key, value);
    }
}

