/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import no.nav.security.token.support.core.api.Protected;
import no.nav.security.token.support.core.api.ProtectedWithClaims;
import no.nav.security.token.support.core.api.RequiredIssuers;
import no.nav.security.token.support.core.api.Unprotected;
import no.nav.security.token.support.core.context.TokenValidationContextHolder;
import no.nav.security.token.support.core.exceptions.AnnotationRequiredException;
import no.nav.security.token.support.core.exceptions.JwtTokenInvalidClaimException;
import no.nav.security.token.support.core.exceptions.JwtTokenMissingException;
import no.nav.security.token.support.core.jwt.JwtToken;
import no.nav.security.token.support.core.utils.JwtTokenUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtTokenAnnotationHandler {
    private static final List<Class<? extends Annotation>> SUPPORTED_ANNOTATIONS = List.of(RequiredIssuers.class, ProtectedWithClaims.class, Protected.class, Unprotected.class);
    private static final Logger LOG = LoggerFactory.getLogger(JwtTokenAnnotationHandler.class);
    private final TokenValidationContextHolder tokenValidationContextHolder;

    public JwtTokenAnnotationHandler(TokenValidationContextHolder tokenValidationContextHolder) {
        this.tokenValidationContextHolder = tokenValidationContextHolder;
    }

    public boolean assertValidAnnotation(Method m) throws AnnotationRequiredException {
        return Optional.ofNullable(this.getAnnotation(m, SUPPORTED_ANNOTATIONS)).map(this::assertValidAnnotation).orElseThrow(() -> new AnnotationRequiredException(m));
    }

    private boolean assertValidAnnotation(Annotation a) {
        if (a instanceof Unprotected) {
            LOG.debug("annotation is of type={}, no token validation performed.", (Object)Unprotected.class.getSimpleName());
            return true;
        }
        if (a instanceof RequiredIssuers) {
            this.handleRequiredIssuers((RequiredIssuers)RequiredIssuers.class.cast(a));
        }
        if (a instanceof ProtectedWithClaims) {
            return this.handleProtectedWithClaims((ProtectedWithClaims)ProtectedWithClaims.class.cast(a));
        }
        if (a instanceof Protected) {
            return this.handleProtected();
        }
        LOG.debug("annotation is unknown,  type={}, no token validation performed. but possible bug so throw exception", a.annotationType());
        return false;
    }

    private boolean handleProtected() {
        LOG.debug("annotation is of type={}, check if context has valid token.", (Object)Protected.class.getSimpleName());
        if (JwtTokenUtil.contextHasValidToken(this.tokenValidationContextHolder)) {
            return true;
        }
        throw new JwtTokenMissingException();
    }

    private boolean handleProtectedWithClaims(ProtectedWithClaims a) {
        LOG.debug("annotation is of type={}, do token validation and claim checking.", (Object)ProtectedWithClaims.class.getSimpleName());
        Optional<JwtToken> jwtToken = JwtTokenUtil.getJwtToken(a.issuer(), this.tokenValidationContextHolder);
        if (jwtToken.isEmpty()) {
            throw new JwtTokenMissingException();
        }
        if (!this.handleProtectedWithClaimsAnnotation(a, jwtToken.get())) {
            throw new JwtTokenInvalidClaimException(a);
        }
        return true;
    }

    private boolean handleRequiredIssuers(RequiredIssuers a) {
        boolean hasToken = false;
        for (ProtectedWithClaims sub : a.value()) {
            Optional<JwtToken> jwtToken = JwtTokenUtil.getJwtToken(sub.issuer(), this.tokenValidationContextHolder);
            if (jwtToken.isEmpty()) continue;
            if (this.handleProtectedWithClaimsAnnotation(sub, jwtToken.get())) {
                return true;
            }
            hasToken = true;
        }
        if (!hasToken) {
            throw new JwtTokenMissingException(a);
        }
        throw new JwtTokenInvalidClaimException(a);
    }

    protected Annotation getAnnotation(Method method, List<Class<? extends Annotation>> types) {
        return Optional.ofNullable(JwtTokenAnnotationHandler.findAnnotation(types, method.getAnnotations())).orElseGet(() -> JwtTokenAnnotationHandler.findAnnotation(types, method.getDeclaringClass().getAnnotations()));
    }

    private static Annotation findAnnotation(List<Class<? extends Annotation>> types, Annotation ... annotations) {
        return Arrays.stream(annotations).filter(a -> types.contains(a.annotationType())).findFirst().orElse(null);
    }

    protected boolean handleProtectedWithClaimsAnnotation(ProtectedWithClaims a, JwtToken jwtToken) {
        return this.handleProtectedWithClaims(a.issuer(), a.claimMap(), a.combineWithOr(), jwtToken);
    }

    protected boolean handleProtectedWithClaims(String issuer, String[] requiredClaims, boolean combineWithOr, JwtToken jwtToken) {
        if (Objects.nonNull(issuer) && issuer.length() > 0) {
            return this.containsRequiredClaims(jwtToken, combineWithOr, requiredClaims);
        }
        return true;
    }

    protected boolean containsRequiredClaims(JwtToken jwtToken, boolean combineWithOr, String ... claims) {
        LOG.debug("choose matching logic based on combineWithOr=" + combineWithOr);
        return combineWithOr ? this.containsAnyClaim(jwtToken, claims) : this.containsAllClaims(jwtToken, claims);
    }

    private boolean containsAllClaims(JwtToken jwtToken, String ... claims) {
        if (claims != null && claims.length > 0) {
            return Arrays.stream(claims).map(claimUnparsed -> claimUnparsed.split("=")).filter(pair -> ((String[])pair).length == 2).allMatch(pair -> jwtToken.containsClaim(pair[0].trim(), pair[1].trim()));
        }
        return true;
    }

    private boolean containsAnyClaim(JwtToken jwtToken, String ... claims) {
        if (claims != null && claims.length > 0) {
            return Arrays.stream(claims).map(claimUnparsed -> claimUnparsed.split("=")).filter(pair -> ((String[])pair).length == 2).anyMatch(pair -> jwtToken.containsClaim(pair[0].trim(), pair[1].trim()));
        }
        LOG.debug("no claims listed, so claim checking is ok.");
        return true;
    }
}

