/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.configuration;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.validation.constraints.NotNull;

public class IssuerProperties {
    @NotNull
    private URL discoveryUrl;
    private List<String> acceptedAudience;
    private String cookieName;
    private URL proxyUrl;
    private boolean usePlaintextForHttps = false;
    private Validation validation = new Validation(Collections.emptyList());
    private JwksCache jwksCache = new JwksCache(null, null);

    public IssuerProperties(URL discoveryUrl) {
        this.discoveryUrl = discoveryUrl;
    }

    public IssuerProperties(URL discoveryUrl, List<String> acceptedAudience) {
        this.discoveryUrl = discoveryUrl;
        this.acceptedAudience = acceptedAudience;
    }

    public IssuerProperties(URL discoveryUrl, List<String> acceptedAudience, String cookieName) {
        this(discoveryUrl, acceptedAudience);
        this.cookieName = cookieName;
    }

    public IssuerProperties(URL discoveryUrl, Validation validation) {
        this(discoveryUrl);
        this.validation = validation;
    }

    public IssuerProperties(URL discoveryUrl, JwksCache jwksCache) {
        this(discoveryUrl);
        this.jwksCache = jwksCache;
    }

    public IssuerProperties(URL discoveryUrl, Validation validation, JwksCache jwksCache) {
        this(discoveryUrl, validation);
        this.jwksCache = jwksCache;
    }

    public IssuerProperties(URL discoveryUrl, List<String> acceptedAudience, String cookieName, Validation validation, JwksCache jwksCache) {
        this(discoveryUrl, acceptedAudience);
        this.cookieName = cookieName;
        this.validation = validation;
        this.jwksCache = jwksCache;
    }

    public URL getDiscoveryUrl() {
        return this.discoveryUrl;
    }

    public List<String> getAcceptedAudience() {
        return this.acceptedAudience;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public URL getProxyUrl() {
        return this.proxyUrl;
    }

    public boolean isUsePlaintextForHttps() {
        return this.usePlaintextForHttps;
    }

    public Validation getValidation() {
        return this.validation;
    }

    public JwksCache getJwksCache() {
        return this.jwksCache;
    }

    public void setDiscoveryUrl(URL discoveryUrl) {
        this.discoveryUrl = discoveryUrl;
    }

    public void setAcceptedAudience(List<String> acceptedAudience) {
        this.acceptedAudience = acceptedAudience;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public void setProxyUrl(URL proxyUrl) {
        this.proxyUrl = proxyUrl;
    }

    public void setUsePlaintextForHttps(boolean usePlaintextForHttps) {
        this.usePlaintextForHttps = usePlaintextForHttps;
    }

    public void setValidation(Validation validation) {
        this.validation = validation;
    }

    public void setJwksCache(JwksCache jwksCache) {
        this.jwksCache = jwksCache;
    }

    public String toString() {
        return "IssuerProperties(discoveryUrl=" + this.getDiscoveryUrl() + ", acceptedAudience=" + this.getAcceptedAudience() + ", cookieName=" + this.getCookieName() + ", proxyUrl=" + this.getProxyUrl() + ", usePlaintextForHttps=" + this.isUsePlaintextForHttps() + ", validation=" + this.getValidation() + ", jwksCache=" + this.getJwksCache() + ")";
    }

    public IssuerProperties() {
    }

    public static class JwksCache {
        private Long lifespan;
        private Long refreshTime;

        public JwksCache(Long lifespan, Long refreshTime) {
            this.lifespan = Optional.ofNullable(lifespan).orElse(null);
            this.refreshTime = Optional.ofNullable(refreshTime).orElse(null);
        }

        public Boolean isConfigured() {
            return this.lifespan != null && this.refreshTime != null;
        }

        public Long getLifespan() {
            return this.lifespan;
        }

        public Long getRefreshTime() {
            return this.refreshTime;
        }

        public void setLifespan(Long lifespan) {
            this.lifespan = lifespan;
        }

        public void setRefreshTime(Long refreshTime) {
            this.refreshTime = refreshTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JwksCache)) {
                return false;
            }
            JwksCache other = (JwksCache)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$lifespan = this.getLifespan();
            Long other$lifespan = other.getLifespan();
            if (this$lifespan == null ? other$lifespan != null : !((Object)this$lifespan).equals(other$lifespan)) {
                return false;
            }
            Long this$refreshTime = this.getRefreshTime();
            Long other$refreshTime = other.getRefreshTime();
            return !(this$refreshTime == null ? other$refreshTime != null : !((Object)this$refreshTime).equals(other$refreshTime));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JwksCache;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $lifespan = this.getLifespan();
            result = result * 59 + ($lifespan == null ? 43 : ((Object)$lifespan).hashCode());
            Long $refreshTime = this.getRefreshTime();
            result = result * 59 + ($refreshTime == null ? 43 : ((Object)$refreshTime).hashCode());
            return result;
        }

        public String toString() {
            return "IssuerProperties.JwksCache(lifespan=" + this.getLifespan() + ", refreshTime=" + this.getRefreshTime() + ")";
        }
    }

    public static class Validation {
        private List<String> optionalClaims;

        public Validation(List<String> optionalClaims) {
            this.optionalClaims = Optional.ofNullable(optionalClaims).orElse(Collections.emptyList());
        }

        public Boolean isConfigured() {
            return !this.optionalClaims.isEmpty();
        }

        public List<String> getOptionalClaims() {
            return this.optionalClaims;
        }

        public void setOptionalClaims(List<String> optionalClaims) {
            this.optionalClaims = optionalClaims;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Validation)) {
                return false;
            }
            Validation other = (Validation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$optionalClaims = this.getOptionalClaims();
            List<String> other$optionalClaims = other.getOptionalClaims();
            return !(this$optionalClaims == null ? other$optionalClaims != null : !((Object)this$optionalClaims).equals(other$optionalClaims));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Validation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $optionalClaims = this.getOptionalClaims();
            result = result * 59 + ($optionalClaims == null ? 43 : ((Object)$optionalClaims).hashCode());
            return result;
        }

        public String toString() {
            return "IssuerProperties.Validation(optionalClaims=" + this.getOptionalClaims() + ")";
        }
    }
}

