/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.configuration;

import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import no.nav.security.token.support.core.configuration.IssuerProperties;
import no.nav.security.token.support.core.configuration.ProxyAwareResourceRetriever;
import no.nav.security.token.support.core.exceptions.MetaDataNotAvailableException;
import no.nav.security.token.support.core.validation.JwtTokenValidator;
import no.nav.security.token.support.core.validation.JwtTokenValidatorFactory;

public class IssuerConfiguration {
    private String name;
    private AuthorizationServerMetadata metadata;
    private final List<String> acceptedAudience;
    private String cookieName;
    private final JwtTokenValidator tokenValidator;
    private ResourceRetriever resourceRetriever;

    public IssuerConfiguration(String name, IssuerProperties issuerProperties, ResourceRetriever resourceRetriever) {
        this.name = name;
        this.resourceRetriever = resourceRetriever;
        this.metadata = IssuerConfiguration.getProviderMetadata(resourceRetriever, issuerProperties.getDiscoveryUrl());
        this.acceptedAudience = issuerProperties.getAcceptedAudience();
        this.cookieName = issuerProperties.getCookieName();
        this.tokenValidator = JwtTokenValidatorFactory.tokenValidator(issuerProperties, this.metadata, resourceRetriever);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getAcceptedAudience() {
        return this.acceptedAudience;
    }

    public JwtTokenValidator getTokenValidator() {
        return this.tokenValidator;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public AuthorizationServerMetadata getMetaData() {
        return this.metadata;
    }

    public void setMetaData(AuthorizationServerMetadata metaData) {
        this.metadata = metaData;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ResourceRetriever getResourceRetriever() {
        if (this.resourceRetriever == null) {
            this.resourceRetriever = new ProxyAwareResourceRetriever();
        }
        return this.resourceRetriever;
    }

    public void setResourceRetriever(ResourceRetriever resourceRetriever) {
        this.resourceRetriever = resourceRetriever;
    }

    protected static AuthorizationServerMetadata getProviderMetadata(ResourceRetriever resourceRetriever, URL url) {
        if (url == null) {
            throw new MetaDataNotAvailableException("discoveryUrl cannot be null, check your configuration.");
        }
        try {
            return AuthorizationServerMetadata.parse((String)resourceRetriever.retrieveResource(url).getContent());
        }
        catch (ParseException | IOException e) {
            throw new MetaDataNotAvailableException(url, (Exception)e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [name=" + this.name + ", metaData=" + this.metadata + ", acceptedAudience=" + this.acceptedAudience + ", cookieName=" + this.cookieName + ", tokenValidator=" + this.tokenValidator + ", resourceRetriever=" + this.resourceRetriever + "]";
    }
}

