/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.exceptions;

import java.util.Arrays;
import java.util.List;
import no.nav.security.token.support.core.api.ProtectedWithClaims;
import no.nav.security.token.support.core.api.RequiredIssuers;

public class JwtTokenMissingException
extends RuntimeException {
    public JwtTokenMissingException(String message) {
        super(message);
    }

    public JwtTokenMissingException(RequiredIssuers ann) {
        this("No valid token found in validation context for any of the issuers " + JwtTokenMissingException.issuers(ann));
    }

    public JwtTokenMissingException() {
        this("No valid token found in validation context");
    }

    private static List<String> issuers(RequiredIssuers ann) {
        return Arrays.stream(ann.value()).map(ProtectedWithClaims::issuer).toList();
    }
}

