/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.exceptions;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import no.nav.security.token.support.core.api.ProtectedWithClaims;
import no.nav.security.token.support.core.api.RequiredIssuers;

public class JwtTokenInvalidClaimException
extends RuntimeException {
    public JwtTokenInvalidClaimException(String message) {
        super(message);
    }

    public JwtTokenInvalidClaimException(RequiredIssuers ann) {
        this("Required claims not present in token for any of " + JwtTokenInvalidClaimException.issuersAndClaims(ann));
    }

    public JwtTokenInvalidClaimException(ProtectedWithClaims ann) {
        this("Required claims not present in token." + Arrays.asList(ann.claimMap()));
    }

    private static Map<String, String[]> issuersAndClaims(RequiredIssuers ann) {
        return Arrays.stream(ann.value()).collect(Collectors.toMap(ProtectedWithClaims::issuer, ProtectedWithClaims::claimMap));
    }
}

