/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.validation;

import com.nimbusds.jose.jwk.source.DefaultJWKSetCache;
import com.nimbusds.jose.jwk.source.JWKSetCache;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import no.nav.security.token.support.core.configuration.IssuerProperties;
import no.nav.security.token.support.core.exceptions.MetaDataNotAvailableException;
import no.nav.security.token.support.core.validation.ConfigurableJwtTokenValidator;
import no.nav.security.token.support.core.validation.DefaultJwtTokenValidator;
import no.nav.security.token.support.core.validation.JwtTokenValidator;

public class JwtTokenValidatorFactory {
    public static JwtTokenValidator tokenValidator(IssuerProperties issuerProperties, AuthorizationServerMetadata metadata, ResourceRetriever resourceRetriever) {
        RemoteJWKSet<SecurityContext> remoteJWKSet = JwtTokenValidatorFactory.remoteJwkSet(issuerProperties, JwtTokenValidatorFactory.getJWKsUrl(metadata), resourceRetriever);
        return JwtTokenValidatorFactory.tokenValidator(issuerProperties, metadata, remoteJWKSet);
    }

    public static JwtTokenValidator tokenValidator(IssuerProperties issuerProperties, AuthorizationServerMetadata metadata, RemoteJWKSet<SecurityContext> remoteJWKSet) {
        if (issuerProperties.getValidation().isConfigured().booleanValue()) {
            return new ConfigurableJwtTokenValidator(metadata.getIssuer().getValue(), issuerProperties.getValidation().getOptionalClaims(), remoteJWKSet);
        }
        return new DefaultJwtTokenValidator(metadata.getIssuer().getValue(), issuerProperties.getAcceptedAudience(), remoteJWKSet);
    }

    private static RemoteJWKSet<SecurityContext> remoteJwkSet(IssuerProperties issuerProperties, URL jwksUrl, ResourceRetriever resourceRetriever) {
        return issuerProperties.getJwksCache().isConfigured() != false ? new RemoteJWKSet(jwksUrl, resourceRetriever, (JWKSetCache)new DefaultJWKSetCache(issuerProperties.getJwksCache().getLifespan().longValue(), issuerProperties.getJwksCache().getRefreshTime().longValue(), TimeUnit.MINUTES)) : new RemoteJWKSet(jwksUrl, resourceRetriever);
    }

    private static URL getJWKsUrl(AuthorizationServerMetadata metaData) {
        try {
            return metaData.getJWKSetURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new MetaDataNotAvailableException(e);
        }
    }
}

