/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.jwt;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import java.text.ParseException;
import no.nav.security.token.support.core.jwt.JwtTokenClaims;

public class JwtToken {
    private final String encodedToken;
    private final JWT jwt;
    private final JwtTokenClaims jwtTokenClaims;

    public JwtToken(String encodedToken) {
        try {
            this.encodedToken = encodedToken;
            this.jwt = JWTParser.parse((String)encodedToken);
            this.jwtTokenClaims = new JwtTokenClaims(this.getJwtClaimsSet());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String getIssuer() {
        return this.jwtTokenClaims.getIssuer();
    }

    public String getSubject() {
        return this.jwtTokenClaims.getSubject();
    }

    public String getTokenAsString() {
        return this.encodedToken;
    }

    public boolean containsClaim(String name, String value) {
        return this.jwtTokenClaims.containsClaim(name, value);
    }

    public JwtTokenClaims getJwtTokenClaims() {
        return this.jwtTokenClaims;
    }

    protected JWT getJwt() {
        return this.jwt;
    }

    private JWTClaimsSet getJwtClaimsSet() throws ParseException {
        return this.jwt.getJWTClaimsSet();
    }
}

