/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.configuration;

import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import no.nav.security.token.support.core.configuration.IssuerProperties;
import no.nav.security.token.support.core.configuration.ProxyAwareResourceRetriever;
import no.nav.security.token.support.core.exceptions.MetaDataNotAvailableException;
import no.nav.security.token.support.core.validation.JwtTokenValidator;
import no.nav.security.token.support.core.validation.JwtTokenValidatorFactory;

public class IssuerConfiguration {
    private final String name;
    private final AuthorizationServerMetadata metadata;
    private final List<String> acceptedAudience;
    private final String cookieName;
    private final String headerName;
    private final JwtTokenValidator tokenValidator;
    private final ResourceRetriever resourceRetriever;

    public IssuerConfiguration(String name, IssuerProperties issuerProperties, ResourceRetriever retriever) {
        this.name = name;
        this.resourceRetriever = Optional.ofNullable(retriever).orElseGet(ProxyAwareResourceRetriever::new);
        this.metadata = IssuerConfiguration.getProviderMetadata(this.resourceRetriever, issuerProperties.getDiscoveryUrl());
        this.acceptedAudience = issuerProperties.getAcceptedAudience();
        this.cookieName = issuerProperties.getCookieName();
        this.headerName = issuerProperties.getHeaderName();
        this.tokenValidator = JwtTokenValidatorFactory.tokenValidator(issuerProperties, this.metadata, this.resourceRetriever);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getAcceptedAudience() {
        return this.acceptedAudience;
    }

    public JwtTokenValidator getTokenValidator() {
        return this.tokenValidator;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public AuthorizationServerMetadata getMetaData() {
        return this.metadata;
    }

    public ResourceRetriever getResourceRetriever() {
        return this.resourceRetriever;
    }

    protected static AuthorizationServerMetadata getProviderMetadata(ResourceRetriever resourceRetriever, URL url) {
        try {
            return AuthorizationServerMetadata.parse((String)resourceRetriever.retrieveResource(url).getContent());
        }
        catch (ParseException | IOException e) {
            throw new MetaDataNotAvailableException("Make sure you are not using proxying in GCP", url, (Exception)e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [name=" + this.name + ", metaData=" + this.metadata + ", acceptedAudience=" + this.acceptedAudience + ", cookieName=" + this.cookieName + ", headerName=" + this.headerName + ", tokenValidator=" + this.tokenValidator + ", resourceRetriever=" + this.resourceRetriever + "]";
    }
}

