/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.utils;

import java.util.Objects;
import no.nav.security.token.support.core.utils.EnvUtil;

public enum Cluster {
    TEST("test"),
    LOCAL("local"),
    DEV_SBS(EnvUtil.DEV_SBS),
    DEV_FSS(EnvUtil.DEV_FSS),
    DEV_GCP(EnvUtil.DEV_GCP),
    PROD_GCP(EnvUtil.PROD_GCP),
    PROD_FSS(EnvUtil.PROD_FSS),
    PROD_SBS(EnvUtil.PROD_SBS);

    private final String navn;

    public static Cluster currentCluster() {
        String current = Cluster.cluster();
        for (Cluster cluster : Cluster.values()) {
            if (!Objects.equals(cluster.navn, current)) continue;
            return cluster;
        }
        return LOCAL;
    }

    public static boolean isProd() {
        String current = Cluster.cluster();
        return Objects.equals(current, EnvUtil.PROD_GCP) || Objects.equals(current, EnvUtil.PROD_FSS);
    }

    private static String cluster() {
        return System.getenv("NAIS_CLUSTER_NAME");
    }

    private Cluster(String navn) {
        this.navn = navn;
    }
}

