/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.validation;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import no.nav.security.token.support.core.exceptions.JwtTokenValidatorException;
import no.nav.security.token.support.core.validation.DefaultJwtClaimsVerifier;
import no.nav.security.token.support.core.validation.JwtTokenValidator;

public class DefaultConfigurableJwtValidator
implements JwtTokenValidator {
    private static final List<String> DEFAULT_REQUIRED_CLAIMS = List.of("aud", "exp", "iat", "iss", "sub");
    private static final Set<String> PROHIBITED_CLAIMS = Collections.emptySet();
    private final JWKSource<SecurityContext> jwkSource;
    private final ConfigurableJWTProcessor<SecurityContext> jwtProcessor;

    public DefaultConfigurableJwtValidator(String issuer, List<String> acceptedAudiences, JWKSource<SecurityContext> jwkSource) {
        this(issuer, acceptedAudiences, null, jwkSource);
    }

    public DefaultConfigurableJwtValidator(String issuer, List<String> acceptedAudiences, List<String> optionalClaims, JWKSource<SecurityContext> jwkSource) {
        acceptedAudiences = Optional.ofNullable(acceptedAudiences).orElse(List.of());
        optionalClaims = Optional.ofNullable(optionalClaims).orElse(List.of());
        Set<String> requiredClaims = DefaultConfigurableJwtValidator.difference(DEFAULT_REQUIRED_CLAIMS, optionalClaims);
        JWTClaimsSet exactMatchClaims = new JWTClaimsSet.Builder().issuer(issuer).build();
        JWSVerificationKeySelector keySelector = new JWSVerificationKeySelector(JWSAlgorithm.RS256, jwkSource);
        DefaultJwtClaimsVerifier claimsVerifier = new DefaultJwtClaimsVerifier(DefaultConfigurableJwtValidator.acceptedAudiences(acceptedAudiences, optionalClaims), exactMatchClaims, requiredClaims, PROHIBITED_CLAIMS);
        DefaultJWTProcessor processor = new DefaultJWTProcessor();
        processor.setJWSKeySelector((JWSKeySelector)keySelector);
        processor.setJWTClaimsSetVerifier(claimsVerifier);
        this.jwkSource = jwkSource;
        this.jwtProcessor = processor;
    }

    @Override
    public void assertValidToken(String tokenString) throws JwtTokenValidatorException {
        try {
            this.jwtProcessor.process(tokenString, null);
        }
        catch (Throwable t) {
            throw new JwtTokenValidatorException("Token validation failed: " + t.getMessage(), t);
        }
    }

    private static Set<String> acceptedAudiences(List<String> acceptedAudiences, List<String> optionalClaims) {
        if (!optionalClaims.contains("aud")) {
            return new HashSet<String>(acceptedAudiences);
        }
        if (acceptedAudiences.isEmpty()) {
            return null;
        }
        ArrayList<String> acceptedAudiencesCopy = new ArrayList<String>(acceptedAudiences);
        acceptedAudiencesCopy.add(null);
        return new HashSet<String>(acceptedAudiencesCopy);
    }

    private static <T> Set<T> difference(List<T> first, List<T> second) {
        return first.stream().filter(c -> !second.contains(c)).collect(Collectors.toUnmodifiableSet());
    }

    protected JWKSource<SecurityContext> getJwkSource() {
        return this.jwkSource;
    }
}

