/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.validation;

import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.jwt.util.DateUtils;
import com.nimbusds.openid.connect.sdk.validators.BadJWTExceptions;
import java.util.Date;
import java.util.Set;

public class DefaultJwtClaimsVerifier<C extends SecurityContext>
extends DefaultJWTClaimsVerifier<C> {
    public DefaultJwtClaimsVerifier(Set<String> acceptedAudience, JWTClaimsSet exactMatchClaims, Set<String> requiredClaims, Set<String> prohibitedClaims) {
        super(acceptedAudience, exactMatchClaims, requiredClaims, prohibitedClaims);
    }

    public void verify(JWTClaimsSet claimsSet, C context) throws BadJWTException {
        Date now;
        super.verify(claimsSet, context);
        Date iat = claimsSet.getIssueTime();
        if (iat != null && !iat.equals(now = new Date()) && !DateUtils.isBefore((Date)iat, (Date)now, (long)super.getMaxClockSkew())) {
            throw BadJWTExceptions.IAT_CLAIM_AHEAD_EXCEPTION;
        }
    }
}

