/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import no.nav.security.token.support.core.configuration.IssuerConfiguration;
import no.nav.security.token.support.core.configuration.MultiIssuerConfiguration;
import no.nav.security.token.support.core.http.HttpRequest;
import no.nav.security.token.support.core.jwt.JwtToken;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\rH\u0002J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lno/nav/security/token/support/core/validation/JwtTokenRetriever;", "", "()V", "BEARER", "", "LOG", "Lorg/slf4j/Logger;", "containsCookieName", "", "configuration", "Lno/nav/security/token/support/core/configuration/MultiIssuerConfiguration;", "cookieName", "extractBearerTokens", "", "headerValues", "getTokensFromCookies", "Lno/nav/security/token/support/core/jwt/JwtToken;", "config", "request", "Lno/nav/security/token/support/core/http/HttpRequest;", "getTokensFromHeader", "retrieveUnvalidatedTokens", "token-validation-core"})
@SourceDebugExtension(value={"SMAP\nJwtTokenRetriever.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JwtTokenRetriever.kt\nno/nav/security/token/support/core/validation/JwtTokenRetriever\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n288#2,2:58\n1549#2:61\n1620#2,3:62\n819#2:65\n847#2,2:66\n766#2:68\n857#2,2:69\n1549#2:71\n1620#2,3:72\n1747#2,3:75\n1549#2:78\n1620#2,3:79\n766#2:82\n857#2,2:83\n1549#2:85\n1620#2,3:86\n1#3:60\n*S KotlinDebug\n*F\n+ 1 JwtTokenRetriever.kt\nno/nav/security/token/support/core/validation/JwtTokenRetriever\n*L\n21#1:58,2\n25#1:61\n25#1:62,3\n26#1:65\n26#1:66,2\n37#1:68\n37#1:69,2\n38#1:71\n38#1:72,3\n48#1:75,3\n54#1:78\n54#1:79,3\n55#1:82\n55#1:83,2\n56#1:85\n56#1:86,3\n*E\n"})
public final class JwtTokenRetriever {
    @NotNull
    public static final JwtTokenRetriever INSTANCE = new JwtTokenRetriever();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String BEARER = "Bearer";

    private JwtTokenRetriever() {
    }

    @JvmStatic
    @NotNull
    public static final List<JwtToken> retrieveUnvalidatedTokens(@NotNull MultiIssuerConfiguration config, @NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return CollectionsKt.plus((Collection)INSTANCE.getTokensFromHeader(config, request), (Iterable)INSTANCE.getTokensFromCookies(config, request));
    }

    /*
     * WARNING - void declaration
     */
    private final List<JwtToken> getTokensFromHeader(MultiIssuerConfiguration config, HttpRequest request) {
        List list;
        try {
            List list2;
            Object v0;
            Iterable $this$firstOrNull$iv;
            block8: {
                LOG.debug("Checking authorization header for tokens using config {}", (Object)config);
                $this$firstOrNull$iv = config.getIssuers().values();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    IssuerConfiguration it = (IssuerConfiguration)element$iv;
                    boolean bl = false;
                    if (!(request.getHeader(it.getHeaderName()) != null)) continue;
                    v0 = element$iv;
                    break block8;
                }
                v0 = null;
            }
            IssuerConfiguration it = v0;
            boolean bl2 = false;
            Optional<IssuerConfiguration> optional = Optional.ofNullable(it);
            Intrinsics.checkNotNullExpressionValue(optional, (String)"let(...)");
            Optional<IssuerConfiguration> issuer = optional;
            if (issuer.isPresent()) {
                void $this$filterNotTo$iv$iv;
                void $this$filterNot$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Object object = request.getHeader(issuer.get().getHeaderName());
                if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(bl2 = new String[]{","}), (boolean)false, (int)0, (int)6, null)) == null) {
                    object = CollectionsKt.emptyList();
                }
                headerValues = object;
                $this$firstOrNull$iv = this.extractBearerTokens((List<String>)headerValues);
                boolean $i$f$map = false;
                void bl2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(new JwtToken((String)p0));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$filterNot = false;
                $this$mapTo$iv$iv = $this$filterNot$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    JwtToken it2 = (JwtToken)element$iv$iv;
                    boolean bl4 = false;
                    if (config.getIssuers().get(it2.getIssuer()) == null) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                headerValues = CollectionsKt.emptyList();
                List it3 = headerValues;
                boolean bl5 = false;
                LOG.debug("No tokens found in authorization header");
                list2 = headerValues;
            }
            list = list2;
        }
        catch (Exception e) {
            List list3;
            List it = list3 = CollectionsKt.emptyList();
            boolean bl = false;
            LOG.warn("Received exception when attempting to extract and parse token from Authorization header", (Throwable)e);
            list = list3;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<JwtToken> getTokensFromCookies(MultiIssuerConfiguration config, HttpRequest request) {
        Object object;
        try {
            List list;
            List list2;
            object = request.getCookies();
            if (object != null && (list2 = ArraysKt.asList((Object[])object)) != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Iterable iterable = list2;
                boolean $i$f$filter22 = false;
                void var7_9 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    HttpRequest.NameValue it = (HttpRequest.NameValue)element$iv$iv;
                    boolean bl = false;
                    if (!INSTANCE.containsCookieName(config, it.getName())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $i$f$filter22 = (List)destination$iv$iv;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    HttpRequest.NameValue bl = (HttpRequest.NameValue)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(new JwtToken(it.getValue()));
                }
                list = (List)destination$iv$iv2;
            } else {
                List list3;
                List it = list3 = CollectionsKt.emptyList();
                boolean bl = false;
                LOG.debug("No tokens found in cookies");
                list = list3;
            }
            object = list;
        }
        catch (Exception e) {
            LOG.warn("Received exception when attempting to extract and parse token from cookie", (Throwable)e);
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final boolean containsCookieName(MultiIssuerConfiguration configuration, String cookieName) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = configuration.getIssuers().values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IssuerConfiguration it = (IssuerConfiguration)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.equals((String)cookieName, (String)it.getCookieName(), (boolean)true)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final List<String> extractBearerTokens(List<String> headerValues) {
        Iterable $this$filterTo$iv$iv;
        List it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = headerValues;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{" "};
            collection.add(StringsKt.split$default((CharSequence)((CharSequence)((Object)it)), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (List)element$iv$iv;
            boolean bl = false;
            if (!(it.size() == 2 && StringsKt.equals((String)((String)it.get(0)), (String)BEARER, (boolean)true))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (List)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((String)it.get(1)))).toString());
        }
        return (List)destination$iv$iv;
    }

    static {
        Logger logger = LoggerFactory.getLogger(JwtTokenRetriever.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

