/*
 * Decompiled with CFR 0.152.
 */
package no.nav.security.token.support.core.configuration;

import com.nimbusds.jose.util.ResourceRetriever;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import no.nav.security.token.support.core.configuration.IssuerConfiguration;
import no.nav.security.token.support.core.configuration.IssuerProperties;
import no.nav.security.token.support.core.configuration.ProxyAwareResourceRetriever;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u00192\u0006\u0010\u001a\u001a\u00020\u0004H\u0007J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0004H\u0016R!\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00040\nj\b\u0012\u0004\u0012\u00020\u0004`\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lno/nav/security/token/support/core/configuration/MultiIssuerConfiguration;", "", "properties", "", "", "Lno/nav/security/token/support/core/configuration/IssuerProperties;", "retriever", "Lcom/nimbusds/jose/util/ResourceRetriever;", "(Ljava/util/Map;Lcom/nimbusds/jose/util/ResourceRetriever;)V", "issuerShortNames", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getIssuerShortNames", "()Ljava/util/ArrayList;", "issuers", "", "Lno/nav/security/token/support/core/configuration/IssuerConfiguration;", "getIssuers", "()Ljava/util/Map;", "getRetriever", "()Lcom/nimbusds/jose/util/ResourceRetriever;", "createIssuerConfiguration", "shortName", "p", "getIssuer", "Ljava/util/Optional;", "name", "loadIssuerConfigurations", "", "toString", "token-validation-core"})
@SourceDebugExtension(value={"SMAP\nMultiIssuerConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiIssuerConfiguration.kt\nno/nav/security/token/support/core/configuration/MultiIssuerConfiguration\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,35:1\n215#2,2:36\n*S KotlinDebug\n*F\n+ 1 MultiIssuerConfiguration.kt\nno/nav/security/token/support/core/configuration/MultiIssuerConfiguration\n*L\n20#1:36,2\n*E\n"})
public final class MultiIssuerConfiguration {
    @NotNull
    private final Map<String, IssuerProperties> properties;
    @NotNull
    private final ResourceRetriever retriever;
    @NotNull
    private final ArrayList<String> issuerShortNames;
    @NotNull
    private final Map<String, IssuerConfiguration> issuers;

    @JvmOverloads
    public MultiIssuerConfiguration(@NotNull Map<String, IssuerProperties> properties, @NotNull ResourceRetriever retriever) {
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)retriever, (String)"retriever");
        this.properties = properties;
        this.retriever = retriever;
        this.issuerShortNames = new ArrayList();
        this.issuers = new HashMap();
        this.loadIssuerConfigurations();
    }

    public /* synthetic */ MultiIssuerConfiguration(Map map, ResourceRetriever resourceRetriever, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            resourceRetriever = (ResourceRetriever)new ProxyAwareResourceRetriever(null, false, 3, null);
        }
        this(map, resourceRetriever);
    }

    @NotNull
    public final ResourceRetriever getRetriever() {
        return this.retriever;
    }

    @NotNull
    public final ArrayList<String> getIssuerShortNames() {
        return this.issuerShortNames;
    }

    @NotNull
    public final Map<String, IssuerConfiguration> getIssuers() {
        return this.issuers;
    }

    @Deprecated(message="Use of Optional not necessary", replaceWith=@ReplaceWith(expression="getIssuers.get(<issuer>)", imports={}), level=DeprecationLevel.WARNING)
    @NotNull
    public final Optional<IssuerConfiguration> getIssuer(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Optional<IssuerConfiguration> optional = Optional.ofNullable(this.issuers.get(name));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    private final void loadIssuerConfigurations() {
        Map<String, IssuerProperties> $this$forEach$iv = this.properties;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, IssuerProperties>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, IssuerProperties> element$iv;
            Map.Entry<String, IssuerProperties> entry = element$iv = iterator.next();
            boolean bl = false;
            String shortName = entry.getKey();
            IssuerProperties p = entry.getValue();
            IssuerConfiguration $this$loadIssuerConfigurations_u24lambda_u241_u24lambda_u240 = this.createIssuerConfiguration(shortName, p);
            boolean bl2 = false;
            this.issuerShortNames.add(shortName);
            this.issuers.put(shortName, $this$loadIssuerConfigurations_u24lambda_u241_u24lambda_u240);
            this.issuers.put(String.valueOf($this$loadIssuerConfigurations_u24lambda_u241_u24lambda_u240.getMetadata().getIssuer()), $this$loadIssuerConfigurations_u24lambda_u241_u24lambda_u240);
        }
    }

    private final IssuerConfiguration createIssuerConfiguration(String shortName, IssuerProperties p) {
        return p.getUsePlaintextForHttps() || p.getProxyUrl() != null ? new IssuerConfiguration(shortName, p, (ResourceRetriever)new ProxyAwareResourceRetriever(p.getProxyUrl(), p.getUsePlaintextForHttps())) : new IssuerConfiguration(shortName, p, this.retriever);
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + " [issuerShortNames=" + this.issuerShortNames + ", resourceRetriever=" + this.retriever + ", issuers=" + this.issuers + ", issuerPropertiesMap=" + this.properties + "]";
    }

    @JvmOverloads
    public MultiIssuerConfiguration(@NotNull Map<String, IssuerProperties> properties) {
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        this(properties, null, 2, null);
    }
}

